# Guia Rápido de Instalação - SGI

## Passo a Passo

### 1. Banco de Dados

```bash
# Acesse o MySQL
mysql -u root -p

# Crie o banco
CREATE DATABASE sgi_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

# Saia do MySQL
exit;

# Importe o schema
mysql -u root -p sgi_db < database/schema.sql
```

### 2. Configuração

Edite o arquivo `app/config/config.php`:

```php
// Altere estas linhas:
define('DB_HOST', 'localhost');        // Seu host MySQL
define('DB_NAME', 'sgi_db');           // Nome do banco
define('DB_USER', 'root');             // Seu usuário MySQL
define('DB_PASS', 'sua_senha');       // Sua senha MySQL
define('BASE_URL', 'http://localhost/impdBahia/public/'); // URL do seu sistema
```

### 3. Permissões (Linux/Mac)

```bash
chmod -R 755 /caminho/para/impdBahia
```

### 4. Acesse o Sistema

Abra no navegador: `http://localhost/impdBahia/public/`

**Login padrão:**
- E-mail: `admin@admin.com`
- Senha: `admin123`

### 5. Primeiro Acesso

1. Faça login com as credenciais padrão
2. Altere a senha do administrador
3. Configure suas igrejas
4. Cadastre pastores e obreiros
5. Comece a usar o sistema!

## Problemas Comuns

### Erro 500
- Verifique os logs de erro do PHP
- Certifique-se de que todas as extensões estão instaladas
- Verifique permissões de arquivos

### Erro de conexão com banco
- Verifique se o MySQL está rodando
- Confirme usuário e senha em `config.php`
- Teste a conexão manualmente

### Página em branco
- Ative exibição de erros em `config.php` (ENVIRONMENT = 'development')
- Verifique logs do servidor web

## Suporte

Consulte o arquivo `README.md` para mais informações detalhadas.

