# SGI - Sistema de Gestão de Igrejas

Sistema completo de gestão para igrejas, desenvolvido em PHP com arquitetura MVC simples, utilizando AdminLTE como framework de interface.

## 🚀 Funcionalidades

- ✅ **Autenticação e Autorização**
  - Login/Logout
  - Perfis de usuário (Administrador Geral, Secretaria, Tesouraria, Pastor, Visualizador)
  - Controle de acesso por perfil

- ✅ **Cadastro de Igrejas** 💒
  - Cadastro completo com endereço, contatos, CNPJ
  - Status ativo/inativo

- ✅ **Cadastro de Pastores** 👨‍⚖️
  - Dados pessoais completos
  - Histórico de transferências
  - Vinculação com igrejas

- ✅ **Cadastro de Obreiros** 🙏
  - Tipos: Diácono, Presbítero, Evangelista, Cooperador, Missionário
  - Histórico de transferências
  - Vinculação com igrejas

- ✅ **Transferências** 🔁
  - Transferência de pastores entre igrejas
  - Transferência de obreiros entre igrejas
  - Histórico completo com timeline

- ✅ **Módulo Financeiro** 💸
  - Lançamentos de entrada e saída
  - Centros de custo (Dízimos, Ofertas, Missões, etc.)
  - Relatórios por período e por centro de custo
  - Saldo consolidado

- ✅ **Dashboard**
  - Estatísticas gerais
  - Últimos movimentos financeiros
  - Últimas igrejas cadastradas

- ✅ **Log de Auditoria**
  - Registro de todas as ações importantes
  - Rastreabilidade completa

## 📋 Requisitos

- PHP 8.0 ou superior
- MySQL 5.7+ ou MariaDB 10.3+
- Servidor web (Apache/Nginx)
- Extensões PHP: PDO, PDO_MySQL, mbstring

## 🔧 Instalação

### 1. Clone ou baixe o projeto

```bash
cd /caminho/do/seu/servidor/web
```

### 2. Configure o banco de dados

1. Crie um banco de dados MySQL:
```sql
CREATE DATABASE sgi_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

2. Importe o schema:
```bash
mysql -u seu_usuario -p sgi_db < database/schema.sql
```

Ou execute o arquivo `database/schema.sql` no seu cliente MySQL.

### 3. Configure a conexão

Edite o arquivo `app/config/config.php` e ajuste as configurações:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'sgi_db');
define('DB_USER', 'seu_usuario');
define('DB_PASS', 'sua_senha');
define('BASE_URL', 'http://localhost/impdBahia/public/');
```

### 4. Configure o servidor web

#### Apache (.htaccess)

Crie um arquivo `.htaccess` na pasta `public`:

```apache
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^(.*)$ index.php [QSA,L]
```

#### Nginx

Configure o servidor para apontar para a pasta `public`:

```nginx
server {
    listen 80;
    server_name seu-dominio.com;
    root /caminho/para/impdBahia/public;
    index index.php;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.0-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

### 5. Permissões (Linux/Mac)

```bash
chmod -R 755 /caminho/para/impdBahia
chmod -R 777 /caminho/para/impdBahia/public/assets (se necessário para uploads)
```

## 🔐 Acesso Inicial

**Usuário padrão:**
- E-mail: `admin@admin.com`
- Senha: `admin123`

⚠️ **IMPORTANTE:** Altere a senha do administrador após o primeiro acesso!

## 📁 Estrutura do Projeto

```
impdBahia/
├── app/
│   ├── config/          # Configurações do sistema
│   ├── controllers/     # Controllers (lógica de controle)
│   ├── models/          # Models (acesso ao banco de dados)
│   ├── views/           # Views (interface)
│   └── helpers/         # Funções auxiliares
├── database/
│   └── schema.sql       # Script de criação do banco
├── public/
│   └── index.php        # Arquivo principal (roteador)
└── README.md
```

## 🎨 Tecnologias Utilizadas

- **Backend:** PHP 8+ (Orientado a Objetos, MVC)
- **Frontend:** HTML5, CSS3, JavaScript, jQuery
- **Framework UI:** AdminLTE 3.2
- **Banco de Dados:** MySQL/MariaDB
- **Ícones:** Font Awesome 6.4
- **Máscaras:** jQuery Mask Plugin

## 🔒 Segurança

- Senhas criptografadas com `password_hash()` (bcrypt)
- Proteção contra SQL Injection (PDO Prepared Statements)
- Sanitização de entradas (XSS protection)
- Controle de acesso por perfil
- Log de auditoria de ações importantes

## 📝 Perfis de Usuário

1. **Administrador Geral** - Acesso total ao sistema
2. **Administrador de Campo/Distrito** - Gestão regional
3. **Secretaria** - Gestão de cadastros e transferências
4. **Tesouraria** - Gestão financeira
5. **Pastor** - Visualização de informações
6. **Visualizador/Leitor** - Apenas leitura

## 🐛 Troubleshooting

### Erro de conexão com banco de dados
- Verifique as credenciais em `app/config/config.php`
- Certifique-se de que o MySQL está rodando
- Verifique se o banco de dados foi criado

### Página em branco
- Verifique os logs de erro do PHP
- Certifique-se de que todas as extensões PHP necessárias estão instaladas
- Verifique permissões de arquivos

### Erro 404 nas rotas
- Configure corretamente o `.htaccess` (Apache) ou configuração do Nginx
- Verifique se o `mod_rewrite` está habilitado (Apache)

## 📞 Suporte

Para dúvidas ou problemas, verifique:
1. Logs de erro do PHP
2. Logs de erro do servidor web
3. Logs de auditoria no sistema (menu Administração)

## 📄 Licença

Este projeto é de uso interno. Todos os direitos reservados.

## 🎯 Próximas Melhorias Sugeridas

- [ ] Exportação de relatórios em PDF
- [ ] Exportação de relatórios em Excel/CSV
- [ ] Gráficos interativos no dashboard
- [ ] Upload de documentos para transferências
- [ ] Notificações por e-mail
- [ ] API REST para integrações
- [ ] App mobile

---

**Desenvolvido com ❤️ para gestão eficiente de igrejas**

