<?php
/**
 * Configurações Gerais do Sistema
 * Sistema de Gestão de Igrejas (SGI)
 */

// Configurações de ambiente
define('ENVIRONMENT', 'development'); // development ou production

// Configurações de URL
define('BASE_URL', 'http://localhost/impdBahia/public/');
define('ASSETS_URL', BASE_URL . 'assets/');

// Configurações de banco de dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'sgi_db');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Configurações de sessão
define('SESSION_NAME', 'SGI_SESSION');
define('SESSION_LIFETIME', 7200); // 2 horas

// Configurações de segurança
define('PASSWORD_MIN_LENGTH', 6);
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 900); // 15 minutos

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Iniciar sessão
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}

// Exibir erros apenas em desenvolvimento
if (ENVIRONMENT === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

