<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../helpers/functions.php';
require_once __DIR__ . '/../models/Usuario.php';

class AuthController
{
    private $usuarioModel;

    public function __construct()
    {
        $this->usuarioModel = new Usuario();
    }

    public function login()
    {
        // Se já estiver logado, redireciona para dashboard
        if (isset($_SESSION['usuario_id'])) {
            redirecionar('index.php?c=Dashboard&a=index');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $email = sanitizar($_POST['email'] ?? '');
            $senha = $_POST['senha'] ?? '';

            if (empty($email) || empty($senha)) {
                setMensagemErro('Preencha todos os campos.');
                include __DIR__ . '/../views/auth/login.php';
                return;
            }

            $usuario = $this->usuarioModel->buscarPorEmail($email);

            if (!$usuario || !password_verify($senha, $usuario['senha'])) {
                setMensagemErro('E-mail ou senha incorretos.');
                include __DIR__ . '/../views/auth/login.php';
                return;
            }

            // Criar sessão
            $_SESSION['usuario_id'] = $usuario['id'];
            $_SESSION['usuario_nome'] = $usuario['nome'];
            $_SESSION['usuario_email'] = $usuario['email'];
            $_SESSION['perfil_id'] = $usuario['id_perfil'];
            $_SESSION['perfil_nome'] = $usuario['perfil_nome'];

            // Atualizar último acesso
            $this->usuarioModel->atualizarUltimoAcesso($usuario['id']);

            // Registrar log
            registrarLog('LOGIN', "Usuário {$usuario['nome']} fez login no sistema", $usuario['id']);

            setMensagemSucesso('Login realizado com sucesso!');
            redirecionar('index.php?c=Dashboard&a=index');
            return;
        }

        include __DIR__ . '/../views/auth/login.php';
    }

    public function logout()
    {
        if (isset($_SESSION['usuario_id'])) {
            registrarLog('LOGOUT', "Usuário {$_SESSION['usuario_nome']} fez logout do sistema", $_SESSION['usuario_id']);
        }

        session_destroy();
        redirecionar('index.php?c=Auth&a=login');
    }
}

