<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../helpers/functions.php';
require_once __DIR__ . '/../models/Igreja.php';
require_once __DIR__ . '/../models/Pastor.php';
require_once __DIR__ . '/../models/Obreiro.php';
require_once __DIR__ . '/../models/MovimentoFinanceiro.php';

class DashboardController
{
    public function __construct()
    {
        verificarLogin();
    }

    public function index()
    {
        $igrejaModel = new Igreja();
        $pastorModel = new Pastor();
        $obreiroModel = new Obreiro();
        $movimentoModel = new MovimentoFinanceiro();

        // Estatísticas gerais
        $totalIgrejas = count($igrejaModel->listarTodos(true));
        $totalPastores = count($pastorModel->listarTodos(['ativo' => 1]));
        $totalObreiros = count($obreiroModel->listarTodos(['ativo' => 1]));

        // Movimentos financeiros do mês atual
        $dataInicio = date('Y-m-01');
        $dataFim = date('Y-m-t');
        $saldoMes = $movimentoModel->calcularSaldo([
            'data_inicio' => $dataInicio,
            'data_fim' => $dataFim
        ]);

        // Últimos movimentos financeiros
        $ultimosMovimentos = $movimentoModel->listarTodos([
            'data_inicio' => $dataInicio,
            'data_fim' => $dataFim
        ]);
        $ultimosMovimentos = array_slice($ultimosMovimentos, 0, 10);

        // Últimas igrejas cadastradas
        $igrejas = $igrejaModel->listarTodos(true);
        $ultimasIgrejas = array_slice($igrejas, 0, 5);

        include __DIR__ . '/../views/layouts/header.php';
        include __DIR__ . '/../views/layouts/sidebar.php';
        include __DIR__ . '/../views/dashboard/index.php';
        include __DIR__ . '/../views/layouts/footer.php';
    }
}

