<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../helpers/functions.php';
require_once __DIR__ . '/../models/Igreja.php';

class IgrejaController
{
    private $igrejaModel;

    public function __construct()
    {
        verificarLogin();
        $this->igrejaModel = new Igreja();
    }

    public function index()
    {
        $igrejas = $this->igrejaModel->listarTodos();
        
        include __DIR__ . '/../views/layouts/header.php';
        include __DIR__ . '/../views/layouts/sidebar.php';
        include __DIR__ . '/../views/igrejas/index.php';
        include __DIR__ . '/../views/layouts/footer.php';
    }

    public function criar()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $dados = [
                'nome' => sanitizar($_POST['nome'] ?? ''),
                'cnpj' => sanitizar($_POST['cnpj'] ?? ''),
                'endereco' => sanitizar($_POST['endereco'] ?? ''),
                'cidade' => sanitizar($_POST['cidade'] ?? ''),
                'estado' => sanitizar($_POST['estado'] ?? ''),
                'cep' => sanitizar($_POST['cep'] ?? ''),
                'telefone' => sanitizar($_POST['telefone'] ?? ''),
                'email' => sanitizar($_POST['email'] ?? ''),
                'ativo' => isset($_POST['ativo']) ? 1 : 0
            ];

            if (empty($dados['nome'])) {
                setMensagemErro('O nome da igreja é obrigatório.');
            } else {
                if ($this->igrejaModel->criar($dados)) {
                    registrarLog('CREATE', "Igreja criada: {$dados['nome']}");
                    setMensagemSucesso('Igreja cadastrada com sucesso!');
                    redirecionar('index.php?c=Igreja&a=index');
                    return;
                } else {
                    setMensagemErro('Erro ao cadastrar igreja.');
                }
            }
        }

        include __DIR__ . '/../views/layouts/header.php';
        include __DIR__ . '/../views/layouts/sidebar.php';
        include __DIR__ . '/../views/igrejas/form.php';
        include __DIR__ . '/../views/layouts/footer.php';
    }

    public function editar()
    {
        $id = $_GET['id'] ?? 0;
        $igreja = $this->igrejaModel->buscarPorId($id);

        if (!$igreja) {
            setMensagemErro('Igreja não encontrada.');
            redirecionar('index.php?c=Igreja&a=index');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $dados = [
                'nome' => sanitizar($_POST['nome'] ?? ''),
                'cnpj' => sanitizar($_POST['cnpj'] ?? ''),
                'endereco' => sanitizar($_POST['endereco'] ?? ''),
                'cidade' => sanitizar($_POST['cidade'] ?? ''),
                'estado' => sanitizar($_POST['estado'] ?? ''),
                'cep' => sanitizar($_POST['cep'] ?? ''),
                'telefone' => sanitizar($_POST['telefone'] ?? ''),
                'email' => sanitizar($_POST['email'] ?? ''),
                'ativo' => isset($_POST['ativo']) ? 1 : 0
            ];

            if (empty($dados['nome'])) {
                setMensagemErro('O nome da igreja é obrigatório.');
            } else {
                if ($this->igrejaModel->atualizar($id, $dados)) {
                    registrarLog('UPDATE', "Igreja atualizada: {$dados['nome']} (ID: {$id})");
                    setMensagemSucesso('Igreja atualizada com sucesso!');
                    redirecionar('index.php?c=Igreja&a=index');
                    return;
                } else {
                    setMensagemErro('Erro ao atualizar igreja.');
                }
            }
        }

        include __DIR__ . '/../views/layouts/header.php';
        include __DIR__ . '/../views/layouts/sidebar.php';
        include __DIR__ . '/../views/igrejas/form.php';
        include __DIR__ . '/../views/layouts/footer.php';
    }

    public function excluir()
    {
        $id = $_GET['id'] ?? 0;
        $igreja = $this->igrejaModel->buscarPorId($id);

        if (!$igreja) {
            setMensagemErro('Igreja não encontrada.');
        } else {
            if ($this->igrejaModel->excluir($id)) {
                registrarLog('DELETE', "Igreja excluída: {$igreja['nome']} (ID: {$id})");
                setMensagemSucesso('Igreja excluída com sucesso!');
            } else {
                setMensagemErro('Erro ao excluir igreja.');
            }
        }

        redirecionar('index.php?c=Igreja&a=index');
    }
}

