<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../helpers/functions.php';
require_once __DIR__ . '/../models/Transferencia.php';
require_once __DIR__ . '/../models/Pastor.php';
require_once __DIR__ . '/../models/Obreiro.php';
require_once __DIR__ . '/../models/Igreja.php';

class TransferenciaController
{
    private $transferenciaModel;
    private $pastorModel;
    private $obreiroModel;
    private $igrejaModel;

    public function __construct()
    {
        verificarLogin();
        $this->transferenciaModel = new Transferencia();
        $this->pastorModel = new Pastor();
        $this->obreiroModel = new Obreiro();
        $this->igrejaModel = new Igreja();
    }

    // ========== PASTORES ==========
    
    public function pastores()
    {
        $filtros = [];
        
        if (!empty($_GET['id_pastor'])) {
            $filtros['id_pastor'] = intval($_GET['id_pastor']);
        }
        
        if (!empty($_GET['data_inicio'])) {
            $filtros['data_inicio'] = $_GET['data_inicio'];
        }
        
        if (!empty($_GET['data_fim'])) {
            $filtros['data_fim'] = $_GET['data_fim'];
        }

        $transferencias = $this->transferenciaModel->listarTransferenciasPastores($filtros);
        $pastores = $this->pastorModel->listarTodos(['ativo' => 1]);
        
        include __DIR__ . '/../views/layouts/header.php';
        include __DIR__ . '/../views/layouts/sidebar.php';
        include __DIR__ . '/../views/transferencias/pastores.php';
        include __DIR__ . '/../views/layouts/footer.php';
    }

    public function criarTransferenciaPastor()
    {
        $pastores = $this->pastorModel->listarTodos(['ativo' => 1]);
        $igrejas = $this->igrejaModel->listarTodos(true);

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $dados = [
                'id_pastor' => intval($_POST['id_pastor'] ?? 0),
                'id_igreja_origem' => !empty($_POST['id_igreja_origem']) ? intval($_POST['id_igreja_origem']) : null,
                'id_igreja_destino' => intval($_POST['id_igreja_destino'] ?? 0),
                'data_transferencia' => $_POST['data_transferencia'] ?? date('Y-m-d'),
                'motivo' => sanitizar($_POST['motivo'] ?? ''),
                'observacoes' => sanitizar($_POST['observacoes'] ?? ''),
                'criado_por' => $_SESSION['usuario_id']
            ];

            if (empty($dados['id_pastor']) || empty($dados['id_igreja_destino'])) {
                setMensagemErro('Pastor e igreja de destino são obrigatórios.');
            } else {
                if ($this->transferenciaModel->criarTransferenciaPastor($dados)) {
                    $pastor = $this->pastorModel->buscarPorId($dados['id_pastor']);
                    registrarLog('TRANSFERENCIA', "Transferência de pastor: {$pastor['nome']} (ID: {$dados['id_pastor']})");
                    setMensagemSucesso('Transferência registrada com sucesso!');
                    redirecionar('index.php?c=Transferencia&a=pastores');
                    return;
                } else {
                    setMensagemErro('Erro ao registrar transferência.');
                }
            }
        }

        include __DIR__ . '/../views/layouts/header.php';
        include __DIR__ . '/../views/layouts/sidebar.php';
        include __DIR__ . '/../views/transferencias/form_pastor.php';
        include __DIR__ . '/../views/layouts/footer.php';
    }

    // ========== OBREIROS ==========
    
    public function obreiros()
    {
        $filtros = [];
        
        if (!empty($_GET['id_obreiro'])) {
            $filtros['id_obreiro'] = intval($_GET['id_obreiro']);
        }
        
        if (!empty($_GET['data_inicio'])) {
            $filtros['data_inicio'] = $_GET['data_inicio'];
        }
        
        if (!empty($_GET['data_fim'])) {
            $filtros['data_fim'] = $_GET['data_fim'];
        }

        $transferencias = $this->transferenciaModel->listarTransferenciasObreiros($filtros);
        $obreiros = $this->obreiroModel->listarTodos(['ativo' => 1]);
        
        include __DIR__ . '/../views/layouts/header.php';
        include __DIR__ . '/../views/layouts/sidebar.php';
        include __DIR__ . '/../views/transferencias/obreiros.php';
        include __DIR__ . '/../views/layouts/footer.php';
    }

    public function criarTransferenciaObreiro()
    {
        $obreiros = $this->obreiroModel->listarTodos(['ativo' => 1]);
        $igrejas = $this->igrejaModel->listarTodos(true);

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $dados = [
                'id_obreiro' => intval($_POST['id_obreiro'] ?? 0),
                'id_igreja_origem' => !empty($_POST['id_igreja_origem']) ? intval($_POST['id_igreja_origem']) : null,
                'id_igreja_destino' => intval($_POST['id_igreja_destino'] ?? 0),
                'data_transferencia' => $_POST['data_transferencia'] ?? date('Y-m-d'),
                'motivo' => sanitizar($_POST['motivo'] ?? ''),
                'observacoes' => sanitizar($_POST['observacoes'] ?? ''),
                'criado_por' => $_SESSION['usuario_id']
            ];

            if (empty($dados['id_obreiro']) || empty($dados['id_igreja_destino'])) {
                setMensagemErro('Obreiro e igreja de destino são obrigatórios.');
            } else {
                if ($this->transferenciaModel->criarTransferenciaObreiro($dados)) {
                    $obreiro = $this->obreiroModel->buscarPorId($dados['id_obreiro']);
                    registrarLog('TRANSFERENCIA', "Transferência de obreiro: {$obreiro['nome']} (ID: {$dados['id_obreiro']})");
                    setMensagemSucesso('Transferência registrada com sucesso!');
                    redirecionar('index.php?c=Transferencia&a=obreiros');
                    return;
                } else {
                    setMensagemErro('Erro ao registrar transferência.');
                }
            }
        }

        include __DIR__ . '/../views/layouts/header.php';
        include __DIR__ . '/../views/layouts/sidebar.php';
        include __DIR__ . '/../views/transferencias/form_obreiro.php';
        include __DIR__ . '/../views/layouts/footer.php';
    }
}

