<?php
require_once __DIR__ . '/../config/database.php';

class CentroCusto
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getConnection();
    }

    public function listarTodos($tipo = null)
    {
        $sql = "SELECT * FROM centros_custo WHERE ativo = 1";
        
        if ($tipo) {
            $sql .= " AND tipo = :tipo";
        }
        
        $sql .= " ORDER BY tipo, nome";
        
        $stmt = $this->db->prepare($sql);
        if ($tipo) {
            $stmt->bindValue(':tipo', $tipo);
        }
        $stmt->execute();
        
        return $stmt->fetchAll();
    }

    public function buscarPorId($id)
    {
        $sql = "SELECT * FROM centros_custo WHERE id = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        $stmt->execute();
        return $stmt->fetch();
    }

    public function criar($dados)
    {
        $sql = "INSERT INTO centros_custo (nome, tipo, descricao, ativo) 
                VALUES (:nome, :tipo, :descricao, :ativo)";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':nome', $dados['nome']);
        $stmt->bindValue(':tipo', $dados['tipo']);
        $stmt->bindValue(':descricao', $dados['descricao'] ?? null);
        $stmt->bindValue(':ativo', $dados['ativo'] ?? 1);
        
        return $stmt->execute();
    }

    public function atualizar($id, $dados)
    {
        $sql = "UPDATE centros_custo SET 
                nome = :nome, 
                tipo = :tipo, 
                descricao = :descricao, 
                ativo = :ativo
                WHERE id = :id";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':nome', $dados['nome']);
        $stmt->bindValue(':tipo', $dados['tipo']);
        $stmt->bindValue(':descricao', $dados['descricao'] ?? null);
        $stmt->bindValue(':ativo', $dados['ativo'] ?? 1);
        $stmt->bindValue(':id', $id);
        
        return $stmt->execute();
    }
}

