<?php
require_once __DIR__ . '/../config/database.php';

class Igreja
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getConnection();
    }

    public function listarTodos($apenasAtivas = false)
    {
        $sql = "SELECT * FROM igrejas";
        
        if ($apenasAtivas) {
            $sql .= " WHERE ativo = 1";
        }
        
        $sql .= " ORDER BY nome";
        
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll();
    }

    public function buscarPorId($id)
    {
        $sql = "SELECT * FROM igrejas WHERE id = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        $stmt->execute();
        return $stmt->fetch();
    }

    public function criar($dados)
    {
        $sql = "INSERT INTO igrejas (nome, cnpj, endereco, cidade, estado, cep, telefone, email, ativo) 
                VALUES (:nome, :cnpj, :endereco, :cidade, :estado, :cep, :telefone, :email, :ativo)";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':nome', $dados['nome']);
        $stmt->bindValue(':cnpj', $dados['cnpj'] ?? null);
        $stmt->bindValue(':endereco', $dados['endereco'] ?? null);
        $stmt->bindValue(':cidade', $dados['cidade'] ?? null);
        $stmt->bindValue(':estado', $dados['estado'] ?? null);
        $stmt->bindValue(':cep', $dados['cep'] ?? null);
        $stmt->bindValue(':telefone', $dados['telefone'] ?? null);
        $stmt->bindValue(':email', $dados['email'] ?? null);
        $stmt->bindValue(':ativo', $dados['ativo'] ?? 1);
        
        return $stmt->execute();
    }

    public function atualizar($id, $dados)
    {
        $sql = "UPDATE igrejas SET 
                nome = :nome, 
                cnpj = :cnpj, 
                endereco = :endereco, 
                cidade = :cidade, 
                estado = :estado, 
                cep = :cep, 
                telefone = :telefone, 
                email = :email, 
                ativo = :ativo,
                atualizado_em = NOW()
                WHERE id = :id";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':nome', $dados['nome']);
        $stmt->bindValue(':cnpj', $dados['cnpj'] ?? null);
        $stmt->bindValue(':endereco', $dados['endereco'] ?? null);
        $stmt->bindValue(':cidade', $dados['cidade'] ?? null);
        $stmt->bindValue(':estado', $dados['estado'] ?? null);
        $stmt->bindValue(':cep', $dados['cep'] ?? null);
        $stmt->bindValue(':telefone', $dados['telefone'] ?? null);
        $stmt->bindValue(':email', $dados['email'] ?? null);
        $stmt->bindValue(':ativo', $dados['ativo'] ?? 1);
        $stmt->bindValue(':id', $id);
        
        return $stmt->execute();
    }

    public function excluir($id)
    {
        $sql = "DELETE FROM igrejas WHERE id = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        return $stmt->execute();
    }

    public function contarPastores($idIgreja)
    {
        $sql = "SELECT COUNT(*) as total FROM pastores WHERE id_igreja_atual = :id_igreja AND ativo = 1";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id_igreja', $idIgreja);
        $stmt->execute();
        $result = $stmt->fetch();
        return $result['total'] ?? 0;
    }

    public function contarObreiros($idIgreja)
    {
        $sql = "SELECT COUNT(*) as total FROM obreiros WHERE id_igreja_atual = :id_igreja AND ativo = 1";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id_igreja', $idIgreja);
        $stmt->execute();
        $result = $stmt->fetch();
        return $result['total'] ?? 0;
    }
}

