<?php
require_once __DIR__ . '/../config/database.php';

class Obreiro
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getConnection();
    }

    public function listarTodos($filtros = [])
    {
        $sql = "SELECT o.*, i.nome AS igreja_nome 
                FROM obreiros o
                LEFT JOIN igrejas i ON i.id = o.id_igreja_atual
                WHERE 1=1";
        
        $params = [];
        
        if (!empty($filtros['nome'])) {
            $sql .= " AND o.nome LIKE :nome";
            $params[':nome'] = '%' . $filtros['nome'] . '%';
        }
        
        if (!empty($filtros['tipo'])) {
            $sql .= " AND o.tipo = :tipo";
            $params[':tipo'] = $filtros['tipo'];
        }
        
        if (!empty($filtros['id_igreja'])) {
            $sql .= " AND o.id_igreja_atual = :id_igreja";
            $params[':id_igreja'] = $filtros['id_igreja'];
        }
        
        if (isset($filtros['ativo'])) {
            $sql .= " AND o.ativo = :ativo";
            $params[':ativo'] = $filtros['ativo'];
        }
        
        $sql .= " ORDER BY o.nome";
        
        $stmt = $this->db->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue($key, $value);
        }
        $stmt->execute();
        
        return $stmt->fetchAll();
    }

    public function buscarPorId($id)
    {
        $sql = "SELECT o.*, i.nome AS igreja_nome 
                FROM obreiros o
                LEFT JOIN igrejas i ON i.id = o.id_igreja_atual
                WHERE o.id = :id";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        $stmt->execute();
        
        return $stmt->fetch();
    }

    public function criar($dados)
    {
        $cpf = !empty($dados['cpf']) ? preg_replace('/[^0-9]/', '', $dados['cpf']) : null;
        
        $sql = "INSERT INTO obreiros (nome, cpf, tipo, telefone, email, endereco, cidade, estado, cep, 
                id_igreja_atual, data_consagracao, observacoes, ativo) 
                VALUES (:nome, :cpf, :tipo, :telefone, :email, :endereco, :cidade, :estado, :cep, 
                :id_igreja_atual, :data_consagracao, :observacoes, :ativo)";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':nome', $dados['nome']);
        $stmt->bindValue(':cpf', $cpf);
        $stmt->bindValue(':tipo', $dados['tipo']);
        $stmt->bindValue(':telefone', $dados['telefone'] ?? null);
        $stmt->bindValue(':email', $dados['email'] ?? null);
        $stmt->bindValue(':endereco', $dados['endereco'] ?? null);
        $stmt->bindValue(':cidade', $dados['cidade'] ?? null);
        $stmt->bindValue(':estado', $dados['estado'] ?? null);
        $stmt->bindValue(':cep', $dados['cep'] ?? null);
        $stmt->bindValue(':id_igreja_atual', !empty($dados['id_igreja_atual']) ? $dados['id_igreja_atual'] : null);
        $stmt->bindValue(':data_consagracao', !empty($dados['data_consagracao']) ? $dados['data_consagracao'] : null);
        $stmt->bindValue(':observacoes', $dados['observacoes'] ?? null);
        $stmt->bindValue(':ativo', $dados['ativo'] ?? 1);
        
        return $stmt->execute();
    }

    public function atualizar($id, $dados)
    {
        $cpf = !empty($dados['cpf']) ? preg_replace('/[^0-9]/', '', $dados['cpf']) : null;
        
        $sql = "UPDATE obreiros SET 
                nome = :nome, 
                cpf = :cpf, 
                tipo = :tipo, 
                telefone = :telefone, 
                email = :email, 
                endereco = :endereco, 
                cidade = :cidade, 
                estado = :estado, 
                cep = :cep, 
                id_igreja_atual = :id_igreja_atual, 
                data_consagracao = :data_consagracao, 
                observacoes = :observacoes, 
                ativo = :ativo,
                atualizado_em = NOW()
                WHERE id = :id";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':nome', $dados['nome']);
        $stmt->bindValue(':cpf', $cpf);
        $stmt->bindValue(':tipo', $dados['tipo']);
        $stmt->bindValue(':telefone', $dados['telefone'] ?? null);
        $stmt->bindValue(':email', $dados['email'] ?? null);
        $stmt->bindValue(':endereco', $dados['endereco'] ?? null);
        $stmt->bindValue(':cidade', $dados['cidade'] ?? null);
        $stmt->bindValue(':estado', $dados['estado'] ?? null);
        $stmt->bindValue(':cep', $dados['cep'] ?? null);
        $stmt->bindValue(':id_igreja_atual', !empty($dados['id_igreja_atual']) ? $dados['id_igreja_atual'] : null);
        $stmt->bindValue(':data_consagracao', !empty($dados['data_consagracao']) ? $dados['data_consagracao'] : null);
        $stmt->bindValue(':observacoes', $dados['observacoes'] ?? null);
        $stmt->bindValue(':ativo', $dados['ativo'] ?? 1);
        $stmt->bindValue(':id', $id);
        
        return $stmt->execute();
    }

    public function excluir($id)
    {
        $sql = "DELETE FROM obreiros WHERE id = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        return $stmt->execute();
    }

    public function atualizarIgrejaAtual($id, $idIgreja)
    {
        $sql = "UPDATE obreiros SET id_igreja_atual = :id_igreja, atualizado_em = NOW() WHERE id = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id_igreja', $idIgreja);
        $stmt->bindValue(':id', $id);
        return $stmt->execute();
    }

    public function listarTipos()
    {
        return [
            'Diácono',
            'Presbítero',
            'Evangelista',
            'Cooperador',
            'Missionário',
            'Outro'
        ];
    }
}

