<?php
require_once __DIR__ . '/../config/database.php';

class Pastor
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getConnection();
    }

    public function listarTodos($filtros = [])
    {
        $sql = "SELECT p.*, i.nome AS igreja_nome 
                FROM pastores p
                LEFT JOIN igrejas i ON i.id = p.id_igreja_atual
                WHERE 1=1";
        
        $params = [];
        
        if (!empty($filtros['nome'])) {
            $sql .= " AND p.nome LIKE :nome";
            $params[':nome'] = '%' . $filtros['nome'] . '%';
        }
        
        if (!empty($filtros['id_igreja'])) {
            $sql .= " AND p.id_igreja_atual = :id_igreja";
            $params[':id_igreja'] = $filtros['id_igreja'];
        }
        
        if (isset($filtros['ativo'])) {
            $sql .= " AND p.ativo = :ativo";
            $params[':ativo'] = $filtros['ativo'];
        }
        
        $sql .= " ORDER BY p.nome";
        
        $stmt = $this->db->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue($key, $value);
        }
        $stmt->execute();
        
        return $stmt->fetchAll();
    }

    public function buscarPorId($id)
    {
        $sql = "SELECT p.*, i.nome AS igreja_nome 
                FROM pastores p
                LEFT JOIN igrejas i ON i.id = p.id_igreja_atual
                WHERE p.id = :id";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        $stmt->execute();
        
        return $stmt->fetch();
    }

    public function buscarPorCPF($cpf)
    {
        $cpf = preg_replace('/[^0-9]/', '', $cpf);
        $sql = "SELECT * FROM pastores WHERE cpf = :cpf";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':cpf', $cpf);
        $stmt->execute();
        return $stmt->fetch();
    }

    public function criar($dados)
    {
        $cpf = preg_replace('/[^0-9]/', '', $dados['cpf']);
        
        $sql = "INSERT INTO pastores (nome, cpf, rg, data_nascimento, estado_civil, telefone, email, 
                endereco, cidade, estado, cep, id_igreja_atual, data_ordenacao, observacoes, ativo) 
                VALUES (:nome, :cpf, :rg, :data_nascimento, :estado_civil, :telefone, :email, 
                :endereco, :cidade, :estado, :cep, :id_igreja_atual, :data_ordenacao, :observacoes, :ativo)";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':nome', $dados['nome']);
        $stmt->bindValue(':cpf', $cpf);
        $stmt->bindValue(':rg', $dados['rg'] ?? null);
        $stmt->bindValue(':data_nascimento', !empty($dados['data_nascimento']) ? $dados['data_nascimento'] : null);
        $stmt->bindValue(':estado_civil', $dados['estado_civil'] ?? null);
        $stmt->bindValue(':telefone', $dados['telefone'] ?? null);
        $stmt->bindValue(':email', $dados['email'] ?? null);
        $stmt->bindValue(':endereco', $dados['endereco'] ?? null);
        $stmt->bindValue(':cidade', $dados['cidade'] ?? null);
        $stmt->bindValue(':estado', $dados['estado'] ?? null);
        $stmt->bindValue(':cep', $dados['cep'] ?? null);
        $stmt->bindValue(':id_igreja_atual', !empty($dados['id_igreja_atual']) ? $dados['id_igreja_atual'] : null);
        $stmt->bindValue(':data_ordenacao', !empty($dados['data_ordenacao']) ? $dados['data_ordenacao'] : null);
        $stmt->bindValue(':observacoes', $dados['observacoes'] ?? null);
        $stmt->bindValue(':ativo', $dados['ativo'] ?? 1);
        
        return $stmt->execute();
    }

    public function atualizar($id, $dados)
    {
        $cpf = preg_replace('/[^0-9]/', '', $dados['cpf']);
        
        $sql = "UPDATE pastores SET 
                nome = :nome, 
                cpf = :cpf, 
                rg = :rg, 
                data_nascimento = :data_nascimento, 
                estado_civil = :estado_civil, 
                telefone = :telefone, 
                email = :email, 
                endereco = :endereco, 
                cidade = :cidade, 
                estado = :estado, 
                cep = :cep, 
                id_igreja_atual = :id_igreja_atual, 
                data_ordenacao = :data_ordenacao, 
                observacoes = :observacoes, 
                ativo = :ativo,
                atualizado_em = NOW()
                WHERE id = :id";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':nome', $dados['nome']);
        $stmt->bindValue(':cpf', $cpf);
        $stmt->bindValue(':rg', $dados['rg'] ?? null);
        $stmt->bindValue(':data_nascimento', !empty($dados['data_nascimento']) ? $dados['data_nascimento'] : null);
        $stmt->bindValue(':estado_civil', $dados['estado_civil'] ?? null);
        $stmt->bindValue(':telefone', $dados['telefone'] ?? null);
        $stmt->bindValue(':email', $dados['email'] ?? null);
        $stmt->bindValue(':endereco', $dados['endereco'] ?? null);
        $stmt->bindValue(':cidade', $dados['cidade'] ?? null);
        $stmt->bindValue(':estado', $dados['estado'] ?? null);
        $stmt->bindValue(':cep', $dados['cep'] ?? null);
        $stmt->bindValue(':id_igreja_atual', !empty($dados['id_igreja_atual']) ? $dados['id_igreja_atual'] : null);
        $stmt->bindValue(':data_ordenacao', !empty($dados['data_ordenacao']) ? $dados['data_ordenacao'] : null);
        $stmt->bindValue(':observacoes', $dados['observacoes'] ?? null);
        $stmt->bindValue(':ativo', $dados['ativo'] ?? 1);
        $stmt->bindValue(':id', $id);
        
        return $stmt->execute();
    }

    public function excluir($id)
    {
        $sql = "DELETE FROM pastores WHERE id = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        return $stmt->execute();
    }

    public function atualizarIgrejaAtual($id, $idIgreja)
    {
        $sql = "UPDATE pastores SET id_igreja_atual = :id_igreja, atualizado_em = NOW() WHERE id = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id_igreja', $idIgreja);
        $stmt->bindValue(':id', $id);
        return $stmt->execute();
    }
}

