<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/Pastor.php';
require_once __DIR__ . '/Obreiro.php';

class Transferencia
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getConnection();
    }

    // ========== TRANSFERÊNCIAS DE PASTORES ==========
    
    public function listarTransferenciasPastores($filtros = [])
    {
        $sql = "SELECT tp.*, 
                p.nome AS pastor_nome, p.cpf AS pastor_cpf,
                io.nome AS igreja_origem_nome,
                id.nome AS igreja_destino_nome,
                u.nome AS criado_por_nome
                FROM transferencias_pastores tp
                INNER JOIN pastores p ON p.id = tp.id_pastor
                LEFT JOIN igrejas io ON io.id = tp.id_igreja_origem
                INNER JOIN igrejas id ON id.id = tp.id_igreja_destino
                INNER JOIN usuarios u ON u.id = tp.criado_por
                WHERE 1=1";
        
        $params = [];
        
        if (!empty($filtros['id_pastor'])) {
            $sql .= " AND tp.id_pastor = :id_pastor";
            $params[':id_pastor'] = $filtros['id_pastor'];
        }
        
        if (!empty($filtros['data_inicio'])) {
            $sql .= " AND tp.data_transferencia >= :data_inicio";
            $params[':data_inicio'] = $filtros['data_inicio'];
        }
        
        if (!empty($filtros['data_fim'])) {
            $sql .= " AND tp.data_transferencia <= :data_fim";
            $params[':data_fim'] = $filtros['data_fim'];
        }
        
        $sql .= " ORDER BY tp.data_transferencia DESC, tp.criado_em DESC";
        
        $stmt = $this->db->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue($key, $value);
        }
        $stmt->execute();
        
        return $stmt->fetchAll();
    }

    public function buscarTransferenciaPastor($id)
    {
        $sql = "SELECT tp.*, 
                p.nome AS pastor_nome, p.cpf AS pastor_cpf,
                io.nome AS igreja_origem_nome,
                id.nome AS igreja_destino_nome,
                u.nome AS criado_por_nome
                FROM transferencias_pastores tp
                INNER JOIN pastores p ON p.id = tp.id_pastor
                LEFT JOIN igrejas io ON io.id = tp.id_igreja_origem
                INNER JOIN igrejas id ON id.id = tp.id_igreja_destino
                INNER JOIN usuarios u ON u.id = tp.criado_por
                WHERE tp.id = :id";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        $stmt->execute();
        
        return $stmt->fetch();
    }

    public function criarTransferenciaPastor($dados)
    {
        $sql = "INSERT INTO transferencias_pastores 
                (id_pastor, id_igreja_origem, id_igreja_destino, data_transferencia, motivo, observacoes, criado_por) 
                VALUES (:id_pastor, :id_igreja_origem, :id_igreja_destino, :data_transferencia, :motivo, :observacoes, :criado_por)";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id_pastor', $dados['id_pastor']);
        $stmt->bindValue(':id_igreja_origem', !empty($dados['id_igreja_origem']) ? $dados['id_igreja_origem'] : null);
        $stmt->bindValue(':id_igreja_destino', $dados['id_igreja_destino']);
        $stmt->bindValue(':data_transferencia', $dados['data_transferencia']);
        $stmt->bindValue(':motivo', $dados['motivo'] ?? null);
        $stmt->bindValue(':observacoes', $dados['observacoes'] ?? null);
        $stmt->bindValue(':criado_por', $dados['criado_por']);
        
        if ($stmt->execute()) {
            // Atualizar igreja atual do pastor
            $pastorModel = new Pastor();
            $pastorModel->atualizarIgrejaAtual($dados['id_pastor'], $dados['id_igreja_destino']);
            return true;
        }
        
        return false;
    }

    public function historicoPastor($idPastor)
    {
        return $this->listarTransferenciasPastores(['id_pastor' => $idPastor]);
    }

    // ========== TRANSFERÊNCIAS DE OBREIROS ==========
    
    public function listarTransferenciasObreiros($filtros = [])
    {
        $sql = "SELECT to.*, 
                o.nome AS obreiro_nome, o.tipo AS obreiro_tipo,
                io.nome AS igreja_origem_nome,
                id.nome AS igreja_destino_nome,
                u.nome AS criado_por_nome
                FROM transferencias_obreiros to
                INNER JOIN obreiros o ON o.id = to.id_obreiro
                LEFT JOIN igrejas io ON io.id = to.id_igreja_origem
                INNER JOIN igrejas id ON id.id = to.id_igreja_destino
                INNER JOIN usuarios u ON u.id = to.criado_por
                WHERE 1=1";
        
        $params = [];
        
        if (!empty($filtros['id_obreiro'])) {
            $sql .= " AND to.id_obreiro = :id_obreiro";
            $params[':id_obreiro'] = $filtros['id_obreiro'];
        }
        
        if (!empty($filtros['data_inicio'])) {
            $sql .= " AND to.data_transferencia >= :data_inicio";
            $params[':data_inicio'] = $filtros['data_inicio'];
        }
        
        if (!empty($filtros['data_fim'])) {
            $sql .= " AND to.data_transferencia <= :data_fim";
            $params[':data_fim'] = $filtros['data_fim'];
        }
        
        $sql .= " ORDER BY to.data_transferencia DESC, to.criado_em DESC";
        
        $stmt = $this->db->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue($key, $value);
        }
        $stmt->execute();
        
        return $stmt->fetchAll();
    }

    public function buscarTransferenciaObreiro($id)
    {
        $sql = "SELECT to.*, 
                o.nome AS obreiro_nome, o.tipo AS obreiro_tipo,
                io.nome AS igreja_origem_nome,
                id.nome AS igreja_destino_nome,
                u.nome AS criado_por_nome
                FROM transferencias_obreiros to
                INNER JOIN obreiros o ON o.id = to.id_obreiro
                LEFT JOIN igrejas io ON io.id = to.id_igreja_origem
                INNER JOIN igrejas id ON id.id = to.id_igreja_destino
                INNER JOIN usuarios u ON u.id = to.criado_por
                WHERE to.id = :id";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        $stmt->execute();
        
        return $stmt->fetch();
    }

    public function criarTransferenciaObreiro($dados)
    {
        $sql = "INSERT INTO transferencias_obreiros 
                (id_obreiro, id_igreja_origem, id_igreja_destino, data_transferencia, motivo, observacoes, criado_por) 
                VALUES (:id_obreiro, :id_igreja_origem, :id_igreja_destino, :data_transferencia, :motivo, :observacoes, :criado_por)";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id_obreiro', $dados['id_obreiro']);
        $stmt->bindValue(':id_igreja_origem', !empty($dados['id_igreja_origem']) ? $dados['id_igreja_origem'] : null);
        $stmt->bindValue(':id_igreja_destino', $dados['id_igreja_destino']);
        $stmt->bindValue(':data_transferencia', $dados['data_transferencia']);
        $stmt->bindValue(':motivo', $dados['motivo'] ?? null);
        $stmt->bindValue(':observacoes', $dados['observacoes'] ?? null);
        $stmt->bindValue(':criado_por', $dados['criado_por']);
        
        if ($stmt->execute()) {
            // Atualizar igreja atual do obreiro
            $obreiroModel = new Obreiro();
            $obreiroModel->atualizarIgrejaAtual($dados['id_obreiro'], $dados['id_igreja_destino']);
            return true;
        }
        
        return false;
    }

    public function historicoObreiro($idObreiro)
    {
        return $this->listarTransferenciasObreiros(['id_obreiro' => $idObreiro]);
    }
}

