<?php
require_once __DIR__ . '/../config/database.php';

class Usuario
{
    private $db;

    public function __construct()
    {
        $this->db = Database::getConnection();
    }

    public function buscarPorEmail($email)
    {
        $sql = "SELECT u.*, p.nome AS perfil_nome 
                FROM usuarios u 
                INNER JOIN perfis p ON p.id = u.id_perfil 
                WHERE u.email = :email AND u.ativo = 1";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':email', $email);
        $stmt->execute();
        
        return $stmt->fetch();
    }

    public function buscarPorId($id)
    {
        $sql = "SELECT u.*, p.nome AS perfil_nome, p.descricao AS perfil_descricao 
                FROM usuarios u 
                INNER JOIN perfis p ON p.id = u.id_perfil 
                WHERE u.id = :id";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        $stmt->execute();
        
        return $stmt->fetch();
    }

    public function listarTodos()
    {
        $sql = "SELECT u.*, p.nome AS perfil_nome 
                FROM usuarios u 
                INNER JOIN perfis p ON p.id = u.id_perfil 
                ORDER BY u.nome";
        
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll();
    }

    public function criar($dados)
    {
        $sql = "INSERT INTO usuarios (nome, email, senha, id_perfil, ativo) 
                VALUES (:nome, :email, :senha, :id_perfil, :ativo)";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':nome', $dados['nome']);
        $stmt->bindValue(':email', $dados['email']);
        $stmt->bindValue(':senha', password_hash($dados['senha'], PASSWORD_DEFAULT));
        $stmt->bindValue(':id_perfil', $dados['id_perfil']);
        $stmt->bindValue(':ativo', $dados['ativo'] ?? 1);
        
        return $stmt->execute();
    }

    public function atualizar($id, $dados)
    {
        $sql = "UPDATE usuarios SET 
                nome = :nome, 
                email = :email, 
                id_perfil = :id_perfil, 
                ativo = :ativo,
                atualizado_em = NOW()";
        
        if (!empty($dados['senha'])) {
            $sql .= ", senha = :senha";
        }
        
        $sql .= " WHERE id = :id";
        
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':nome', $dados['nome']);
        $stmt->bindValue(':email', $dados['email']);
        $stmt->bindValue(':id_perfil', $dados['id_perfil']);
        $stmt->bindValue(':ativo', $dados['ativo'] ?? 1);
        $stmt->bindValue(':id', $id);
        
        if (!empty($dados['senha'])) {
            $stmt->bindValue(':senha', password_hash($dados['senha'], PASSWORD_DEFAULT));
        }
        
        return $stmt->execute();
    }

    public function atualizarUltimoAcesso($id)
    {
        $sql = "UPDATE usuarios SET ultimo_acesso = NOW() WHERE id = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        return $stmt->execute();
    }

    public function excluir($id)
    {
        $sql = "DELETE FROM usuarios WHERE id = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->bindValue(':id', $id);
        return $stmt->execute();
    }

    public function listarPerfis()
    {
        $sql = "SELECT * FROM perfis ORDER BY id";
        $stmt = $this->db->query($sql);
        return $stmt->fetchAll();
    }
}

