<?php
$pageTitle = 'Dashboard';
?>

<!-- Small boxes (Stat box) -->
<div class="row">
  <div class="col-lg-3 col-6">
    <!-- small box -->
    <div class="small-box bg-info">
      <div class="inner">
        <h3><?php echo $totalIgrejas ?? 0; ?></h3>
        <p>💒 Igrejas Cadastradas</p>
      </div>
      <div class="icon">
        <i class="fas fa-church"></i>
      </div>
      <a href="<?php echo BASE_URL; ?>index.php?c=Igreja&a=index" class="small-box-footer">
        Mais informações <i class="fas fa-arrow-circle-right"></i>
      </a>
    </div>
  </div>
  
  <div class="col-lg-3 col-6">
    <!-- small box -->
    <div class="small-box bg-success">
      <div class="inner">
        <h3><?php echo $totalPastores ?? 0; ?></h3>
        <p>👨‍⚖️ Pastores Ativos</p>
      </div>
      <div class="icon">
        <i class="fas fa-user-tie"></i>
      </div>
      <a href="<?php echo BASE_URL; ?>index.php?c=Pastor&a=index" class="small-box-footer">
        Mais informações <i class="fas fa-arrow-circle-right"></i>
      </a>
    </div>
  </div>
  
  <div class="col-lg-3 col-6">
    <!-- small box -->
    <div class="small-box bg-warning">
      <div class="inner">
        <h3><?php echo $totalObreiros ?? 0; ?></h3>
        <p>🙏 Obreiros Ativos</p>
      </div>
      <div class="icon">
        <i class="fas fa-praying-hands"></i>
      </div>
      <a href="<?php echo BASE_URL; ?>index.php?c=Obreiro&a=index" class="small-box-footer">
        Mais informações <i class="fas fa-arrow-circle-right"></i>
      </a>
    </div>
  </div>
  
  <div class="col-lg-3 col-6">
    <!-- small box -->
    <div class="small-box bg-danger">
      <div class="inner">
        <h3><?php echo formatarMoeda($saldoMes['saldo'] ?? 0); ?></h3>
        <p>💸 Saldo do Mês</p>
      </div>
      <div class="icon">
        <i class="fas fa-dollar-sign"></i>
      </div>
      <a href="<?php echo BASE_URL; ?>index.php?c=Financeiro&a=index" class="small-box-footer">
        Mais informações <i class="fas fa-arrow-circle-right"></i>
      </a>
    </div>
  </div>
</div>
<!-- /.row -->

<div class="row">
  <div class="col-md-6">
    <!-- Recent Movimentos Financeiros -->
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">
          <i class="fas fa-dollar-sign mr-1"></i>
          Últimos Movimentos Financeiros
        </h3>
      </div>
      <!-- /.card-header -->
      <div class="card-body p-0">
        <table class="table table-sm">
          <thead>
            <tr>
              <th>Data</th>
              <th>Descrição</th>
              <th>Tipo</th>
              <th class="text-right">Valor</th>
            </tr>
          </thead>
          <tbody>
            <?php if (empty($ultimosMovimentos)): ?>
              <tr>
                <td colspan="4" class="text-center text-muted">Nenhum movimento encontrado</td>
              </tr>
            <?php else: ?>
              <?php foreach ($ultimosMovimentos as $mov): ?>
                <tr>
                  <td><?php echo formatarData($mov['data_movimento']); ?></td>
                  <td><?php echo htmlspecialchars($mov['descricao'] ?: '-'); ?></td>
                  <td>
                    <?php if ($mov['tipo'] == 'ENTRADA'): ?>
                      <span class="badge badge-success">Entrada</span>
                    <?php else: ?>
                      <span class="badge badge-danger">Saída</span>
                    <?php endif; ?>
                  </td>
                  <td class="text-right">
                    <?php echo formatarMoeda($mov['valor']); ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      <!-- /.card-body -->
      <div class="card-footer text-center">
        <a href="<?php echo BASE_URL; ?>index.php?c=Financeiro&a=index" class="uppercase">Ver todos os movimentos</a>
      </div>
      <!-- /.card-footer -->
    </div>
    <!-- /.card -->
  </div>

  <div class="col-md-6">
    <!-- Recent Igrejas -->
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">
          <i class="fas fa-church mr-1"></i>
          Últimas Igrejas Cadastradas
        </h3>
      </div>
      <!-- /.card-header -->
      <div class="card-body p-0">
        <ul class="products-list product-list-in-card pl-2 pr-2">
          <?php if (empty($ultimasIgrejas)): ?>
            <li class="item">
              <div class="product-info">
                <span class="product-description text-muted">Nenhuma igreja cadastrada</span>
              </div>
            </li>
          <?php else: ?>
            <?php foreach ($ultimasIgrejas as $igreja): ?>
              <li class="item">
                <div class="product-info">
                  <a href="<?php echo BASE_URL; ?>index.php?c=Igreja&a=editar&id=<?php echo $igreja['id']; ?>" class="product-title">
                    <?php echo htmlspecialchars($igreja['nome']); ?>
                  </a>
                  <span class="product-description">
                    <?php echo htmlspecialchars($igreja['cidade'] ?? ''); ?>
                    <?php if (!empty($igreja['estado'])): ?>
                      - <?php echo htmlspecialchars($igreja['estado']); ?>
                    <?php endif; ?>
                  </span>
                </div>
              </li>
            <?php endforeach; ?>
          <?php endif; ?>
        </ul>
      </div>
      <!-- /.card-body -->
      <div class="card-footer text-center">
        <a href="<?php echo BASE_URL; ?>index.php?c=Igreja&a=index" class="uppercase">Ver todas as igrejas</a>
      </div>
      <!-- /.card-footer -->
    </div>
    <!-- /.card -->
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

