<?php
$isEdit = isset($movimento) && !empty($movimento);
$pageTitle = $isEdit ? 'Editar Movimento Financeiro' : 'Novo Movimento Financeiro';
$breadcrumb = [
    ['label' => 'Financeiro', 'url' => BASE_URL . 'index.php?c=Financeiro&a=index'],
    ['label' => $isEdit ? 'Editar' : 'Novo', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-md-12">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">💸 <?php echo $isEdit ? 'Editar' : 'Registrar'; ?> Movimento Financeiro</h3>
      </div>
      <!-- /.card-header -->
      <form action="<?php echo BASE_URL; ?>index.php?c=Financeiro&a=<?php echo $isEdit ? 'editar&id=' . $movimento['id'] : 'criar'; ?>" method="post">
        <div class="card-body">
          <div class="row">
            <div class="col-md-3">
              <div class="form-group">
                <label for="data_movimento">Data <span class="text-danger">*</span></label>
                <input type="date" class="form-control" id="data_movimento" name="data_movimento" 
                       value="<?php echo htmlspecialchars($movimento['data_movimento'] ?? date('Y-m-d')); ?>" required>
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="tipo">Tipo <span class="text-danger">*</span></label>
                <select class="form-control" id="tipo" name="tipo" required>
                  <option value="ENTRADA" <?php echo (!isset($movimento) || $movimento['tipo'] == 'ENTRADA') ? 'selected' : ''; ?>>Entrada</option>
                  <option value="SAIDA" <?php echo (isset($movimento) && $movimento['tipo'] == 'SAIDA') ? 'selected' : ''; ?>>Saída</option>
                </select>
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="valor">Valor <span class="text-danger">*</span></label>
                <input type="text" class="form-control mask-money" id="valor" name="valor" 
                       value="<?php echo isset($movimento) ? number_format($movimento['valor'], 2, ',', '.') : ''; ?>" 
                       placeholder="0,00" required>
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="forma_pagamento">Forma de Pagamento</label>
                <select class="form-control" id="forma_pagamento" name="forma_pagamento">
                  <option value="">Selecione...</option>
                  <option value="Dinheiro" <?php echo (isset($movimento) && $movimento['forma_pagamento'] == 'Dinheiro') ? 'selected' : ''; ?>>Dinheiro</option>
                  <option value="PIX" <?php echo (isset($movimento) && $movimento['forma_pagamento'] == 'PIX') ? 'selected' : ''; ?>>PIX</option>
                  <option value="Transferência" <?php echo (isset($movimento) && $movimento['forma_pagamento'] == 'Transferência') ? 'selected' : ''; ?>>Transferência</option>
                  <option value="Cheque" <?php echo (isset($movimento) && $movimento['forma_pagamento'] == 'Cheque') ? 'selected' : ''; ?>>Cheque</option>
                </select>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="id_centro_custo">Centro de Custo <span class="text-danger">*</span></label>
                <select class="form-control" id="id_centro_custo" name="id_centro_custo" required>
                  <option value="">Selecione...</option>
                  <?php 
                  $tipoMovimento = isset($movimento) && !empty($movimento) ? $movimento['tipo'] : 'ENTRADA';
                  $centrosFiltrados = $tipoMovimento == 'ENTRADA' ? $centrosCustoEntrada : $centrosCustoSaida;
                  foreach ($centrosFiltrados as $cc): 
                  ?>
                    <option value="<?php echo $cc['id']; ?>" 
                            <?php echo (isset($movimento) && $movimento['id_centro_custo'] == $cc['id']) ? 'selected' : ''; ?>>
                      <?php echo htmlspecialchars($cc['nome']); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="id_igreja">Igreja</label>
                <select class="form-control" id="id_igreja" name="id_igreja">
                  <option value="">Selecione...</option>
                  <?php foreach ($igrejas as $igreja): ?>
                    <option value="<?php echo $igreja['id']; ?>" 
                            <?php echo (isset($movimento) && $movimento['id_igreja'] == $igreja['id']) ? 'selected' : ''; ?>>
                      <?php echo htmlspecialchars($igreja['nome']); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
          </div>

          <div class="form-group">
            <label for="descricao">Descrição</label>
            <input type="text" class="form-control" id="descricao" name="descricao" 
                   value="<?php echo htmlspecialchars($movimento['descricao'] ?? ''); ?>" 
                   placeholder="Breve descrição do movimento...">
          </div>

          <div class="form-group">
            <label for="observacoes">Observações</label>
            <textarea class="form-control" id="observacoes" name="observacoes" rows="3"><?php echo htmlspecialchars($movimento['observacoes'] ?? ''); ?></textarea>
          </div>
        </div>
        <!-- /.card-body -->
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Salvar
          </button>
          <a href="<?php echo BASE_URL; ?>index.php?c=Financeiro&a=index" class="btn btn-default">
            <i class="fas fa-times"></i> Cancelar
          </a>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
// Atualizar centros de custo quando tipo mudar
document.getElementById('tipo').addEventListener('change', function() {
  // Recarregar página com tipo selecionado para atualizar centros de custo
  // Ou fazer via AJAX (implementação futura)
});
</script>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

