<?php
$pageTitle = 'Movimentos Financeiros';
$breadcrumb = [
    ['label' => 'Financeiro', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">💸 Movimentos Financeiros</h3>
        <div class="card-tools">
          <a href="<?php echo BASE_URL; ?>index.php?c=Financeiro&a=criar" class="btn btn-primary btn-sm">
            <i class="fas fa-plus"></i> Novo Lançamento
          </a>
        </div>
      </div>
      <!-- /.card-header -->
      <div class="card-body">
        <!-- Filtros -->
        <form method="get" action="<?php echo BASE_URL; ?>index.php?c=Financeiro&a=index" class="mb-3">
          <div class="row">
            <div class="col-md-2">
              <input type="date" name="data_inicio" class="form-control" 
                     value="<?php echo htmlspecialchars($_GET['data_inicio'] ?? date('Y-m-01')); ?>">
            </div>
            <div class="col-md-2">
              <input type="date" name="data_fim" class="form-control" 
                     value="<?php echo htmlspecialchars($_GET['data_fim'] ?? date('Y-m-t')); ?>">
            </div>
            <div class="col-md-2">
              <select name="tipo" class="form-control">
                <option value="">Todos</option>
                <option value="ENTRADA" <?php echo (isset($_GET['tipo']) && $_GET['tipo'] == 'ENTRADA') ? 'selected' : ''; ?>>Entradas</option>
                <option value="SAIDA" <?php echo (isset($_GET['tipo']) && $_GET['tipo'] == 'SAIDA') ? 'selected' : ''; ?>>Saídas</option>
              </select>
            </div>
            <div class="col-md-3">
              <select name="id_igreja" class="form-control">
                <option value="">Todas as igrejas</option>
                <?php foreach ($igrejas as $igreja): ?>
                  <option value="<?php echo $igreja['id']; ?>" 
                          <?php echo (isset($_GET['id_igreja']) && $_GET['id_igreja'] == $igreja['id']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($igreja['nome']); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-3">
              <button type="submit" class="btn btn-info">
                <i class="fas fa-search"></i> Filtrar
              </button>
              <a href="<?php echo BASE_URL; ?>index.php?c=Financeiro&a=relatorio" class="btn btn-success">
                <i class="fas fa-chart-line"></i> Relatórios
              </a>
            </div>
          </div>
        </form>

        <!-- Resumo -->
        <div class="row mb-3">
          <div class="col-md-4">
            <div class="info-box">
              <span class="info-box-icon bg-success"><i class="fas fa-arrow-down"></i></span>
              <div class="info-box-content">
                <span class="info-box-text">Total Entradas</span>
                <span class="info-box-number"><?php echo formatarMoeda($saldo['entradas']); ?></span>
              </div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="info-box">
              <span class="info-box-icon bg-danger"><i class="fas fa-arrow-up"></i></span>
              <div class="info-box-content">
                <span class="info-box-text">Total Saídas</span>
                <span class="info-box-number"><?php echo formatarMoeda($saldo['saidas']); ?></span>
              </div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="info-box">
              <span class="info-box-icon bg-info"><i class="fas fa-dollar-sign"></i></span>
              <div class="info-box-content">
                <span class="info-box-text">Saldo</span>
                <span class="info-box-number"><?php echo formatarMoeda($saldo['saldo']); ?></span>
              </div>
            </div>
          </div>
        </div>

        <div class="table-responsive">
          <table class="table table-hover">
            <thead>
              <tr>
                <th>Data</th>
                <th>Descrição</th>
                <th>Centro de Custo</th>
                <th>Igreja</th>
                <th>Tipo</th>
                <th class="text-right">Valor</th>
                <th>Ações</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($movimentos)): ?>
                <tr>
                  <td colspan="7" class="text-center text-muted">Nenhum movimento encontrado</td>
                </tr>
              <?php else: ?>
                <?php foreach ($movimentos as $mov): ?>
                  <tr>
                    <td><?php echo formatarData($mov['data_movimento']); ?></td>
                    <td><?php echo htmlspecialchars($mov['descricao'] ?: '-'); ?></td>
                    <td><?php echo htmlspecialchars($mov['centro_custo_nome']); ?></td>
                    <td><?php echo htmlspecialchars($mov['igreja_nome'] ?? '-'); ?></td>
                    <td>
                      <?php if ($mov['tipo'] == 'ENTRADA'): ?>
                        <span class="badge badge-success">Entrada</span>
                      <?php else: ?>
                        <span class="badge badge-danger">Saída</span>
                      <?php endif; ?>
                    </td>
                    <td class="text-right">
                      <?php echo formatarMoeda($mov['valor']); ?>
                    </td>
                    <td>
                      <a href="<?php echo BASE_URL; ?>index.php?c=Financeiro&a=editar&id=<?php echo $mov['id']; ?>" 
                         class="btn btn-sm btn-warning" title="Editar">
                        <i class="fas fa-edit"></i>
                      </a>
                      <a href="<?php echo BASE_URL; ?>index.php?c=Financeiro&a=excluir&id=<?php echo $mov['id']; ?>" 
                         class="btn btn-sm btn-danger" 
                         onclick="return confirm('Tem certeza que deseja excluir este movimento?');" 
                         title="Excluir">
                        <i class="fas fa-trash"></i>
                      </a>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
      <!-- /.card-body -->
    </div>
    <!-- /.card -->
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

