<?php
$pageTitle = 'Relatórios Financeiros';
$breadcrumb = [
    ['label' => 'Financeiro', 'url' => BASE_URL . 'index.php?c=Financeiro&a=index'],
    ['label' => 'Relatórios', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">📊 Relatórios Financeiros</h3>
      </div>
      <!-- /.card-header -->
      <div class="card-body">
        <!-- Filtros -->
        <form method="get" action="<?php echo BASE_URL; ?>index.php?c=Financeiro&a=relatorio" class="mb-3">
          <div class="row">
            <div class="col-md-3">
              <input type="date" name="data_inicio" class="form-control" 
                     value="<?php echo htmlspecialchars($_GET['data_inicio'] ?? date('Y-m-01')); ?>">
            </div>
            <div class="col-md-3">
              <input type="date" name="data_fim" class="form-control" 
                     value="<?php echo htmlspecialchars($_GET['data_fim'] ?? date('Y-m-t')); ?>">
            </div>
            <div class="col-md-3">
              <select name="id_igreja" class="form-control">
                <option value="">Todas as igrejas</option>
                <?php foreach ($igrejas as $igreja): ?>
                  <option value="<?php echo $igreja['id']; ?>" 
                          <?php echo (isset($_GET['id_igreja']) && $_GET['id_igreja'] == $igreja['id']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($igreja['nome']); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-3">
              <button type="submit" class="btn btn-info">
                <i class="fas fa-search"></i> Filtrar
              </button>
            </div>
          </div>
        </form>

        <!-- Resumo Geral -->
        <div class="row mb-4">
          <div class="col-md-4">
            <div class="info-box">
              <span class="info-box-icon bg-success"><i class="fas fa-arrow-down"></i></span>
              <div class="info-box-content">
                <span class="info-box-text">Total Entradas</span>
                <span class="info-box-number"><?php echo formatarMoeda($saldo['entradas']); ?></span>
              </div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="info-box">
              <span class="info-box-icon bg-danger"><i class="fas fa-arrow-up"></i></span>
              <div class="info-box-content">
                <span class="info-box-text">Total Saídas</span>
                <span class="info-box-number"><?php echo formatarMoeda($saldo['saidas']); ?></span>
              </div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="info-box">
              <span class="info-box-icon bg-info"><i class="fas fa-dollar-sign"></i></span>
              <div class="info-box-content">
                <span class="info-box-text">Saldo</span>
                <span class="info-box-number"><?php echo formatarMoeda($saldo['saldo']); ?></span>
              </div>
            </div>
          </div>
        </div>

        <!-- Resumo por Centro de Custo -->
        <div class="card">
          <div class="card-header">
            <h3 class="card-title">Resumo por Centro de Custo</h3>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-bordered">
                <thead>
                  <tr>
                    <th>Centro de Custo</th>
                    <th>Tipo</th>
                    <th class="text-right">Total Entradas</th>
                    <th class="text-right">Total Saídas</th>
                    <th class="text-right">Saldo</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if (empty($resumoPorCentroCusto)): ?>
                    <tr>
                      <td colspan="5" class="text-center text-muted">Nenhum dado encontrado</td>
                    </tr>
                  <?php else: ?>
                    <?php foreach ($resumoPorCentroCusto as $resumo): ?>
                      <tr>
                        <td><?php echo htmlspecialchars($resumo['centro_custo']); ?></td>
                        <td>
                          <?php if ($resumo['tipo'] == 'ENTRADA'): ?>
                            <span class="badge badge-success">Entrada</span>
                          <?php else: ?>
                            <span class="badge badge-danger">Saída</span>
                          <?php endif; ?>
                        </td>
                        <td class="text-right"><?php echo formatarMoeda($resumo['total_entradas'] ?? 0); ?></td>
                        <td class="text-right"><?php echo formatarMoeda($resumo['total_saidas'] ?? 0); ?></td>
                        <td class="text-right">
                          <?php 
                          $saldoCC = ($resumo['total_entradas'] ?? 0) - ($resumo['total_saidas'] ?? 0);
                          $class = $saldoCC >= 0 ? 'text-success' : 'text-danger';
                          ?>
                          <span class="<?php echo $class; ?>">
                            <?php echo formatarMoeda($saldoCC); ?>
                          </span>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
      <!-- /.card-body -->
    </div>
    <!-- /.card -->
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

