<?php
$isEdit = isset($igreja) && !empty($igreja);
$pageTitle = $isEdit ? 'Editar Igreja' : 'Nova Igreja';
$breadcrumb = [
    ['label' => 'Igrejas', 'url' => BASE_URL . 'index.php?c=Igreja&a=index'],
    ['label' => $isEdit ? 'Editar' : 'Nova', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-md-12">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">💒 <?php echo $isEdit ? 'Editar' : 'Cadastrar'; ?> Igreja</h3>
      </div>
      <!-- /.card-header -->
      <form action="<?php echo BASE_URL; ?>index.php?c=Igreja&a=<?php echo $isEdit ? 'editar&id=' . $igreja['id'] : 'criar'; ?>" method="post">
        <div class="card-body">
          <div class="row">
            <div class="col-md-8">
              <div class="form-group">
                <label for="nome">Nome da Igreja <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nome" name="nome" 
                       value="<?php echo htmlspecialchars($igreja['nome'] ?? ''); ?>" required>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="cnpj">CNPJ</label>
                <input type="text" class="form-control mask-cnpj" id="cnpj" name="cnpj" 
                       value="<?php echo htmlspecialchars($igreja['cnpj'] ?? ''); ?>">
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-8">
              <div class="form-group">
                <label for="endereco">Endereço</label>
                <input type="text" class="form-control" id="endereco" name="endereco" 
                       value="<?php echo htmlspecialchars($igreja['endereco'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="cep">CEP</label>
                <input type="text" class="form-control mask-cep" id="cep" name="cep" 
                       value="<?php echo htmlspecialchars($igreja['cep'] ?? ''); ?>">
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="cidade">Cidade</label>
                <input type="text" class="form-control" id="cidade" name="cidade" 
                       value="<?php echo htmlspecialchars($igreja['cidade'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-2">
              <div class="form-group">
                <label for="estado">Estado</label>
                <input type="text" class="form-control" id="estado" name="estado" maxlength="2" 
                       value="<?php echo htmlspecialchars($igreja['estado'] ?? ''); ?>" 
                       placeholder="BA">
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="telefone">Telefone</label>
                <input type="text" class="form-control mask-telefone" id="telefone" name="telefone" 
                       value="<?php echo htmlspecialchars($igreja['telefone'] ?? ''); ?>">
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="email">E-mail</label>
                <input type="email" class="form-control" id="email" name="email" 
                       value="<?php echo htmlspecialchars($igreja['email'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <div class="custom-control custom-switch mt-4">
                  <input type="checkbox" class="custom-control-input" id="ativo" name="ativo" 
                         <?php echo (!isset($igreja) || $igreja['ativo']) ? 'checked' : ''; ?>>
                  <label class="custom-control-label" for="ativo">Igreja Ativa</label>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /.card-body -->
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Salvar
          </button>
          <a href="<?php echo BASE_URL; ?>index.php?c=Igreja&a=index" class="btn btn-default">
            <i class="fas fa-times"></i> Cancelar
          </a>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

