<?php
$pageTitle = 'Igrejas';
$breadcrumb = [
    ['label' => 'Igrejas', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">💒 Lista de Igrejas</h3>
        <div class="card-tools">
          <a href="<?php echo BASE_URL; ?>index.php?c=Igreja&a=criar" class="btn btn-primary btn-sm">
            <i class="fas fa-plus"></i> Nova Igreja
          </a>
        </div>
      </div>
      <!-- /.card-header -->
      <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th>ID</th>
              <th>Nome</th>
              <th>Cidade/Estado</th>
              <th>Telefone</th>
              <th>Status</th>
              <th>Ações</th>
            </tr>
          </thead>
          <tbody>
            <?php if (empty($igrejas)): ?>
              <tr>
                <td colspan="6" class="text-center text-muted">Nenhuma igreja cadastrada</td>
              </tr>
            <?php else: ?>
              <?php foreach ($igrejas as $igreja): ?>
                <tr>
                  <td><?php echo $igreja['id']; ?></td>
                  <td><?php echo htmlspecialchars($igreja['nome']); ?></td>
                  <td>
                    <?php echo htmlspecialchars($igreja['cidade'] ?? '-'); ?>
                    <?php if (!empty($igreja['estado'])): ?>
                      / <?php echo htmlspecialchars($igreja['estado']); ?>
                    <?php endif; ?>
                  </td>
                  <td><?php echo htmlspecialchars($igreja['telefone'] ?? '-'); ?></td>
                  <td>
                    <?php if ($igreja['ativo']): ?>
                      <span class="badge badge-success">Ativa</span>
                    <?php else: ?>
                      <span class="badge badge-secondary">Inativa</span>
                    <?php endif; ?>
                  </td>
                  <td>
                    <a href="<?php echo BASE_URL; ?>index.php?c=Igreja&a=editar&id=<?php echo $igreja['id']; ?>" 
                       class="btn btn-sm btn-info" title="Editar">
                      <i class="fas fa-edit"></i>
                    </a>
                    <a href="<?php echo BASE_URL; ?>index.php?c=Igreja&a=excluir&id=<?php echo $igreja['id']; ?>" 
                       class="btn btn-sm btn-danger" 
                       onclick="return confirm('Tem certeza que deseja excluir esta igreja?');" 
                       title="Excluir">
                      <i class="fas fa-trash"></i>
                    </a>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      <!-- /.card-body -->
    </div>
    <!-- /.card -->
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

