  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0"><?php echo $pageTitle ?? 'Dashboard'; ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo BASE_URL; ?>index.php?c=Dashboard&a=index">Home</a></li>
              <?php if (isset($breadcrumb)): ?>
                <?php foreach ($breadcrumb as $item): ?>
                  <li class="breadcrumb-item <?php echo isset($item['active']) && $item['active'] ? 'active' : ''; ?>">
                    <?php if (isset($item['active']) && $item['active']): ?>
                      <?php echo htmlspecialchars($item['label']); ?>
                    <?php else: ?>
                      <a href="<?php echo $item['url']; ?>"><?php echo htmlspecialchars($item['label']); ?></a>
                    <?php endif; ?>
                  </li>
                <?php endforeach; ?>
              <?php endif; ?>
            </ol>
          </div>
        </div>
      </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        
        <!-- Mensagens de Sucesso/Erro -->
        <?php $sucesso = getMensagemSucesso(); ?>
        <?php if ($sucesso): ?>
          <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="icon fas fa-check"></i> <?php echo htmlspecialchars($sucesso); ?>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
        <?php endif; ?>

        <?php $erro = getMensagemErro(); ?>
        <?php if ($erro): ?>
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="icon fas fa-ban"></i> <?php echo htmlspecialchars($erro); ?>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
        <?php endif; ?>

