<?php
$isEdit = isset($obreiro) && !empty($obreiro);
$pageTitle = $isEdit ? 'Editar Obreiro' : 'Novo Obreiro';
$breadcrumb = [
    ['label' => 'Obreiros', 'url' => BASE_URL . 'index.php?c=Obreiro&a=index'],
    ['label' => $isEdit ? 'Editar' : 'Novo', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-md-12">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">🙏 <?php echo $isEdit ? 'Editar' : 'Cadastrar'; ?> Obreiro</h3>
      </div>
      <!-- /.card-header -->
      <form action="<?php echo BASE_URL; ?>index.php?c=Obreiro&a=<?php echo $isEdit ? 'editar&id=' . $obreiro['id'] : 'criar'; ?>" method="post">
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="nome">Nome Completo <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nome" name="nome" 
                       value="<?php echo htmlspecialchars($obreiro['nome'] ?? ''); ?>" required>
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="cpf">CPF</label>
                <input type="text" class="form-control mask-cpf" id="cpf" name="cpf" 
                       value="<?php echo htmlspecialchars($obreiro['cpf'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="tipo">Tipo <span class="text-danger">*</span></label>
                <select class="form-control" id="tipo" name="tipo" required>
                  <option value="">Selecione...</option>
                  <?php foreach ($tipos as $tipo): ?>
                    <option value="<?php echo htmlspecialchars($tipo); ?>" 
                            <?php echo (isset($obreiro['tipo']) && $obreiro['tipo'] == $tipo) ? 'selected' : ''; ?>>
                      <?php echo htmlspecialchars($tipo); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-3">
              <div class="form-group">
                <label for="data_consagracao">Data de Consagração</label>
                <input type="date" class="form-control" id="data_consagracao" name="data_consagracao" 
                       value="<?php echo htmlspecialchars($obreiro['data_consagracao'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="telefone">Telefone</label>
                <input type="text" class="form-control mask-telefone" id="telefone" name="telefone" 
                       value="<?php echo htmlspecialchars($obreiro['telefone'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="email">E-mail</label>
                <input type="email" class="form-control" id="email" name="email" 
                       value="<?php echo htmlspecialchars($obreiro['email'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="id_igreja_atual">Igreja Atual</label>
                <select class="form-control" id="id_igreja_atual" name="id_igreja_atual">
                  <option value="">Selecione...</option>
                  <?php foreach ($igrejas as $igreja): ?>
                    <option value="<?php echo $igreja['id']; ?>" 
                            <?php echo (isset($obreiro['id_igreja_atual']) && $obreiro['id_igreja_atual'] == $igreja['id']) ? 'selected' : ''; ?>>
                      <?php echo htmlspecialchars($igreja['nome']); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-8">
              <div class="form-group">
                <label for="endereco">Endereço</label>
                <input type="text" class="form-control" id="endereco" name="endereco" 
                       value="<?php echo htmlspecialchars($obreiro['endereco'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-2">
              <div class="form-group">
                <label for="cep">CEP</label>
                <input type="text" class="form-control mask-cep" id="cep" name="cep" 
                       value="<?php echo htmlspecialchars($obreiro['cep'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-2">
              <div class="form-group">
                <label for="estado">Estado</label>
                <input type="text" class="form-control" id="estado" name="estado" maxlength="2" 
                       value="<?php echo htmlspecialchars($obreiro['estado'] ?? ''); ?>" placeholder="BA">
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="cidade">Cidade</label>
                <input type="text" class="form-control" id="cidade" name="cidade" 
                       value="<?php echo htmlspecialchars($obreiro['cidade'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <div class="custom-control custom-switch mt-4">
                  <input type="checkbox" class="custom-control-input" id="ativo" name="ativo" 
                         <?php echo (!isset($obreiro) || $obreiro['ativo']) ? 'checked' : ''; ?>>
                  <label class="custom-control-label" for="ativo">Obreiro Ativo</label>
                </div>
              </div>
            </div>
          </div>

          <div class="form-group">
            <label for="observacoes">Observações</label>
            <textarea class="form-control" id="observacoes" name="observacoes" rows="3"><?php echo htmlspecialchars($obreiro['observacoes'] ?? ''); ?></textarea>
          </div>
        </div>
        <!-- /.card-body -->
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Salvar
          </button>
          <a href="<?php echo BASE_URL; ?>index.php?c=Obreiro&a=index" class="btn btn-default">
            <i class="fas fa-times"></i> Cancelar
          </a>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

