<?php
$pageTitle = 'Obreiros';
$breadcrumb = [
    ['label' => 'Obreiros', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">🙏 Lista de Obreiros</h3>
        <div class="card-tools">
          <a href="<?php echo BASE_URL; ?>index.php?c=Obreiro&a=criar" class="btn btn-primary btn-sm">
            <i class="fas fa-plus"></i> Novo Obreiro
          </a>
        </div>
      </div>
      <!-- /.card-header -->
      <div class="card-body">
        <!-- Filtros -->
        <form method="get" action="<?php echo BASE_URL; ?>index.php?c=Obreiro&a=index" class="mb-3">
          <div class="row">
            <div class="col-md-3">
              <input type="text" name="nome" class="form-control" placeholder="Buscar por nome..." 
                     value="<?php echo htmlspecialchars($_GET['nome'] ?? ''); ?>">
            </div>
            <div class="col-md-2">
              <select name="tipo" class="form-control">
                <option value="">Todos os tipos</option>
                <?php foreach ($tipos as $tipo): ?>
                  <option value="<?php echo htmlspecialchars($tipo); ?>" 
                          <?php echo (isset($_GET['tipo']) && $_GET['tipo'] == $tipo) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($tipo); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-3">
              <select name="id_igreja" class="form-control">
                <option value="">Todas as igrejas</option>
                <?php foreach ($igrejas as $igreja): ?>
                  <option value="<?php echo $igreja['id']; ?>" 
                          <?php echo (isset($_GET['id_igreja']) && $_GET['id_igreja'] == $igreja['id']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($igreja['nome']); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-2">
              <select name="ativo" class="form-control">
                <option value="1" <?php echo (!isset($_GET['ativo']) || $_GET['ativo'] == '1') ? 'selected' : ''; ?>>Ativos</option>
                <option value="0" <?php echo (isset($_GET['ativo']) && $_GET['ativo'] == '0') ? 'selected' : ''; ?>>Inativos</option>
              </select>
            </div>
            <div class="col-md-2">
              <button type="submit" class="btn btn-info">
                <i class="fas fa-search"></i> Filtrar
              </button>
            </div>
          </div>
        </form>

        <div class="table-responsive">
          <table class="table table-hover">
            <thead>
              <tr>
                <th>Nome</th>
                <th>Tipo</th>
                <th>Igreja Atual</th>
                <th>Telefone</th>
                <th>Status</th>
                <th>Ações</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($obreiros)): ?>
                <tr>
                  <td colspan="6" class="text-center text-muted">Nenhum obreiro encontrado</td>
                </tr>
              <?php else: ?>
                <?php foreach ($obreiros as $obreiro): ?>
                  <tr>
                    <td><?php echo htmlspecialchars($obreiro['nome']); ?></td>
                    <td><span class="badge badge-info"><?php echo htmlspecialchars($obreiro['tipo']); ?></span></td>
                    <td><?php echo htmlspecialchars($obreiro['igreja_nome'] ?? '-'); ?></td>
                    <td><?php echo formatarTelefone($obreiro['telefone'] ?? '-'); ?></td>
                    <td>
                      <?php if ($obreiro['ativo']): ?>
                        <span class="badge badge-success">Ativo</span>
                      <?php else: ?>
                        <span class="badge badge-secondary">Inativo</span>
                      <?php endif; ?>
                    </td>
                    <td>
                      <a href="<?php echo BASE_URL; ?>index.php?c=Obreiro&a=visualizar&id=<?php echo $obreiro['id']; ?>" 
                         class="btn btn-sm btn-info" title="Visualizar">
                        <i class="fas fa-eye"></i>
                      </a>
                      <a href="<?php echo BASE_URL; ?>index.php?c=Obreiro&a=editar&id=<?php echo $obreiro['id']; ?>" 
                         class="btn btn-sm btn-warning" title="Editar">
                        <i class="fas fa-edit"></i>
                      </a>
                      <a href="<?php echo BASE_URL; ?>index.php?c=Obreiro&a=excluir&id=<?php echo $obreiro['id']; ?>" 
                         class="btn btn-sm btn-danger" 
                         onclick="return confirm('Tem certeza que deseja excluir este obreiro?');" 
                         title="Excluir">
                        <i class="fas fa-trash"></i>
                      </a>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
      <!-- /.card-body -->
    </div>
    <!-- /.card -->
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

