<?php
$pageTitle = 'Detalhes do Obreiro';
$breadcrumb = [
    ['label' => 'Obreiros', 'url' => BASE_URL . 'index.php?c=Obreiro&a=index'],
    ['label' => 'Detalhes', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-md-12">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">🙏 <?php echo htmlspecialchars($obreiro['nome']); ?></h3>
        <div class="card-tools">
          <a href="<?php echo BASE_URL; ?>index.php?c=Obreiro&a=editar&id=<?php echo $obreiro['id']; ?>" class="btn btn-warning btn-sm">
            <i class="fas fa-edit"></i> Editar
          </a>
        </div>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-md-6">
            <h5>Dados Pessoais</h5>
            <table class="table table-sm">
              <tr>
                <th width="40%">Nome:</th>
                <td><?php echo htmlspecialchars($obreiro['nome']); ?></td>
              </tr>
              <tr>
                <th>CPF:</th>
                <td><?php echo !empty($obreiro['cpf']) ? formatarCPF($obreiro['cpf']) : '-'; ?></td>
              </tr>
              <tr>
                <th>Tipo:</th>
                <td><span class="badge badge-info"><?php echo htmlspecialchars($obreiro['tipo']); ?></span></td>
              </tr>
              <tr>
                <th>Data de Consagração:</th>
                <td><?php echo formatarData($obreiro['data_consagracao']); ?></td>
              </tr>
            </table>
          </div>
          <div class="col-md-6">
            <h5>Contato</h5>
            <table class="table table-sm">
              <tr>
                <th width="40%">Telefone:</th>
                <td><?php echo formatarTelefone($obreiro['telefone'] ?? '-'); ?></td>
              </tr>
              <tr>
                <th>E-mail:</th>
                <td><?php echo htmlspecialchars($obreiro['email'] ?? '-'); ?></td>
              </tr>
              <tr>
                <th>Endereço:</th>
                <td><?php echo htmlspecialchars($obreiro['endereco'] ?? '-'); ?></td>
              </tr>
              <tr>
                <th>Cidade/Estado:</th>
                <td>
                  <?php echo htmlspecialchars($obreiro['cidade'] ?? ''); ?>
                  <?php if (!empty($obreiro['estado'])): ?>
                    / <?php echo htmlspecialchars($obreiro['estado']); ?>
                  <?php endif; ?>
                </td>
              </tr>
              <tr>
                <th>Igreja Atual:</th>
                <td><?php echo htmlspecialchars($obreiro['igreja_nome'] ?? '-'); ?></td>
              </tr>
            </table>
          </div>
        </div>

        <?php if (!empty($obreiro['observacoes'])): ?>
          <div class="row mt-3">
            <div class="col-12">
              <h5>Observações</h5>
              <p><?php echo nl2br(htmlspecialchars($obreiro['observacoes'])); ?></p>
            </div>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <!-- Histórico de Transferências -->
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">Histórico de Transferências 🔁</h3>
      </div>
      <div class="card-body">
        <?php if (empty($historico)): ?>
          <p class="text-muted">Nenhuma transferência registrada.</p>
        <?php else: ?>
          <div class="timeline">
            <?php foreach ($historico as $transf): ?>
              <div class="time-label">
                <span class="bg-blue"><?php echo formatarData($transf['data_transferencia']); ?></span>
              </div>
              <div>
                <i class="fas fa-exchange-alt bg-blue"></i>
                <div class="timeline-item">
                  <span class="time"><i class="fas fa-clock"></i> <?php echo formatarData($transf['criado_em'], 'd/m/Y H:i'); ?></span>
                  <h3 class="timeline-header">
                    Transferência de 
                    <strong><?php echo htmlspecialchars($transf['igreja_origem_nome'] ?? 'Sem igreja'); ?></strong>
                    para
                    <strong><?php echo htmlspecialchars($transf['igreja_destino_nome']); ?></strong>
                  </h3>
                  <?php if (!empty($transf['motivo'])): ?>
                    <div class="timeline-body">
                      <strong>Motivo:</strong> <?php echo htmlspecialchars($transf['motivo']); ?>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

