<?php
$isEdit = isset($pastor) && !empty($pastor);
$pageTitle = $isEdit ? 'Editar Pastor' : 'Novo Pastor';
$breadcrumb = [
    ['label' => 'Pastores', 'url' => BASE_URL . 'index.php?c=Pastor&a=index'],
    ['label' => $isEdit ? 'Editar' : 'Novo', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-md-12">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">👨‍⚖️ <?php echo $isEdit ? 'Editar' : 'Cadastrar'; ?> Pastor</h3>
      </div>
      <!-- /.card-header -->
      <form action="<?php echo BASE_URL; ?>index.php?c=Pastor&a=<?php echo $isEdit ? 'editar&id=' . $pastor['id'] : 'criar'; ?>" method="post">
        <div class="card-body">
          <div class="row">
            <div class="col-md-8">
              <div class="form-group">
                <label for="nome">Nome Completo <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nome" name="nome" 
                       value="<?php echo htmlspecialchars($pastor['nome'] ?? ''); ?>" required>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="cpf">CPF <span class="text-danger">*</span></label>
                <input type="text" class="form-control mask-cpf" id="cpf" name="cpf" 
                       value="<?php echo htmlspecialchars($pastor['cpf'] ?? ''); ?>" required>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-3">
              <div class="form-group">
                <label for="rg">RG</label>
                <input type="text" class="form-control" id="rg" name="rg" 
                       value="<?php echo htmlspecialchars($pastor['rg'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="data_nascimento">Data de Nascimento</label>
                <input type="date" class="form-control" id="data_nascimento" name="data_nascimento" 
                       value="<?php echo htmlspecialchars($pastor['data_nascimento'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="estado_civil">Estado Civil</label>
                <select class="form-control" id="estado_civil" name="estado_civil">
                  <option value="">Selecione...</option>
                  <option value="Solteiro" <?php echo (isset($pastor['estado_civil']) && $pastor['estado_civil'] == 'Solteiro') ? 'selected' : ''; ?>>Solteiro</option>
                  <option value="Casado" <?php echo (isset($pastor['estado_civil']) && $pastor['estado_civil'] == 'Casado') ? 'selected' : ''; ?>>Casado</option>
                  <option value="Divorciado" <?php echo (isset($pastor['estado_civil']) && $pastor['estado_civil'] == 'Divorciado') ? 'selected' : ''; ?>>Divorciado</option>
                  <option value="Viúvo" <?php echo (isset($pastor['estado_civil']) && $pastor['estado_civil'] == 'Viúvo') ? 'selected' : ''; ?>>Viúvo</option>
                </select>
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="data_ordenacao">Data de Ordenação</label>
                <input type="date" class="form-control" id="data_ordenacao" name="data_ordenacao" 
                       value="<?php echo htmlspecialchars($pastor['data_ordenacao'] ?? ''); ?>">
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-4">
              <div class="form-group">
                <label for="telefone">Telefone</label>
                <input type="text" class="form-control mask-telefone" id="telefone" name="telefone" 
                       value="<?php echo htmlspecialchars($pastor['telefone'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="email">E-mail</label>
                <input type="email" class="form-control" id="email" name="email" 
                       value="<?php echo htmlspecialchars($pastor['email'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label for="id_igreja_atual">Igreja Atual</label>
                <select class="form-control" id="id_igreja_atual" name="id_igreja_atual">
                  <option value="">Selecione...</option>
                  <?php foreach ($igrejas as $igreja): ?>
                    <option value="<?php echo $igreja['id']; ?>" 
                            <?php echo (isset($pastor['id_igreja_atual']) && $pastor['id_igreja_atual'] == $igreja['id']) ? 'selected' : ''; ?>>
                      <?php echo htmlspecialchars($igreja['nome']); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-8">
              <div class="form-group">
                <label for="endereco">Endereço</label>
                <input type="text" class="form-control" id="endereco" name="endereco" 
                       value="<?php echo htmlspecialchars($pastor['endereco'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-2">
              <div class="form-group">
                <label for="cep">CEP</label>
                <input type="text" class="form-control mask-cep" id="cep" name="cep" 
                       value="<?php echo htmlspecialchars($pastor['cep'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-2">
              <div class="form-group">
                <label for="estado">Estado</label>
                <input type="text" class="form-control" id="estado" name="estado" maxlength="2" 
                       value="<?php echo htmlspecialchars($pastor['estado'] ?? ''); ?>" placeholder="BA">
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="cidade">Cidade</label>
                <input type="text" class="form-control" id="cidade" name="cidade" 
                       value="<?php echo htmlspecialchars($pastor['cidade'] ?? ''); ?>">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <div class="custom-control custom-switch mt-4">
                  <input type="checkbox" class="custom-control-input" id="ativo" name="ativo" 
                         <?php echo (!isset($pastor) || $pastor['ativo']) ? 'checked' : ''; ?>>
                  <label class="custom-control-label" for="ativo">Pastor Ativo</label>
                </div>
              </div>
            </div>
          </div>

          <div class="form-group">
            <label for="observacoes">Observações</label>
            <textarea class="form-control" id="observacoes" name="observacoes" rows="3"><?php echo htmlspecialchars($pastor['observacoes'] ?? ''); ?></textarea>
          </div>
        </div>
        <!-- /.card-body -->
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Salvar
          </button>
          <a href="<?php echo BASE_URL; ?>index.php?c=Pastor&a=index" class="btn btn-default">
            <i class="fas fa-times"></i> Cancelar
          </a>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

