<?php
$pageTitle = 'Nova Transferência de Pastor';
$breadcrumb = [
    ['label' => 'Transferências', 'url' => BASE_URL . 'index.php?c=Transferencia&a=pastores'],
    ['label' => 'Nova', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-md-12">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">🔁 Registrar Transferência de Pastor</h3>
      </div>
      <!-- /.card-header -->
      <form action="<?php echo BASE_URL; ?>index.php?c=Transferencia&a=criarTransferenciaPastor" method="post">
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="id_pastor">Pastor <span class="text-danger">*</span></label>
                <select class="form-control" id="id_pastor" name="id_pastor" required>
                  <option value="">Selecione o pastor...</option>
                  <?php foreach ($pastores as $pastor): ?>
                    <option value="<?php echo $pastor['id']; ?>">
                      <?php echo htmlspecialchars($pastor['nome']); ?>
                      <?php if (!empty($pastor['igreja_nome'])): ?>
                        - <?php echo htmlspecialchars($pastor['igreja_nome']); ?>
                      <?php endif; ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="data_transferencia">Data da Transferência <span class="text-danger">*</span></label>
                <input type="date" class="form-control" id="data_transferencia" name="data_transferencia" 
                       value="<?php echo date('Y-m-d'); ?>" required>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="id_igreja_origem">Igreja de Origem</label>
                <select class="form-control" id="id_igreja_origem" name="id_igreja_origem">
                  <option value="">Selecione...</option>
                  <?php foreach ($igrejas as $igreja): ?>
                    <option value="<?php echo $igreja['id']; ?>">
                      <?php echo htmlspecialchars($igreja['nome']); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="id_igreja_destino">Igreja de Destino <span class="text-danger">*</span></label>
                <select class="form-control" id="id_igreja_destino" name="id_igreja_destino" required>
                  <option value="">Selecione...</option>
                  <?php foreach ($igrejas as $igreja): ?>
                    <option value="<?php echo $igreja['id']; ?>">
                      <?php echo htmlspecialchars($igreja['nome']); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
          </div>

          <div class="form-group">
            <label for="motivo">Motivo</label>
            <textarea class="form-control" id="motivo" name="motivo" rows="2" 
                      placeholder="Informe o motivo da transferência..."></textarea>
          </div>

          <div class="form-group">
            <label for="observacoes">Observações</label>
            <textarea class="form-control" id="observacoes" name="observacoes" rows="3"></textarea>
          </div>
        </div>
        <!-- /.card-body -->
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Registrar Transferência
          </button>
          <a href="<?php echo BASE_URL; ?>index.php?c=Transferencia&a=pastores" class="btn btn-default">
            <i class="fas fa-times"></i> Cancelar
          </a>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

