<?php
$pageTitle = 'Transferências de Obreiros';
$breadcrumb = [
    ['label' => 'Transferências', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">🔁 Transferências de Obreiros</h3>
        <div class="card-tools">
          <a href="<?php echo BASE_URL; ?>index.php?c=Transferencia&a=criarTransferenciaObreiro" class="btn btn-primary btn-sm">
            <i class="fas fa-plus"></i> Nova Transferência
          </a>
        </div>
      </div>
      <!-- /.card-header -->
      <div class="card-body">
        <!-- Filtros -->
        <form method="get" action="<?php echo BASE_URL; ?>index.php?c=Transferencia&a=obreiros" class="mb-3">
          <div class="row">
            <div class="col-md-3">
              <select name="id_obreiro" class="form-control">
                <option value="">Todos os obreiros</option>
                <?php foreach ($obreiros as $obreiro): ?>
                  <option value="<?php echo $obreiro['id']; ?>" 
                          <?php echo (isset($_GET['id_obreiro']) && $_GET['id_obreiro'] == $obreiro['id']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($obreiro['nome']); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-3">
              <input type="date" name="data_inicio" class="form-control" 
                     value="<?php echo htmlspecialchars($_GET['data_inicio'] ?? ''); ?>" placeholder="Data início">
            </div>
            <div class="col-md-3">
              <input type="date" name="data_fim" class="form-control" 
                     value="<?php echo htmlspecialchars($_GET['data_fim'] ?? ''); ?>" placeholder="Data fim">
            </div>
            <div class="col-md-3">
              <button type="submit" class="btn btn-info">
                <i class="fas fa-search"></i> Filtrar
              </button>
            </div>
          </div>
        </form>

        <div class="table-responsive">
          <table class="table table-hover">
            <thead>
              <tr>
                <th>Data</th>
                <th>Obreiro</th>
                <th>Tipo</th>
                <th>Origem</th>
                <th>Destino</th>
                <th>Motivo</th>
                <th>Registrado por</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($transferencias)): ?>
                <tr>
                  <td colspan="7" class="text-center text-muted">Nenhuma transferência encontrada</td>
                </tr>
              <?php else: ?>
                <?php foreach ($transferencias as $transf): ?>
                  <tr>
                    <td><?php echo formatarData($transf['data_transferencia']); ?></td>
                    <td><?php echo htmlspecialchars($transf['obreiro_nome']); ?></td>
                    <td><span class="badge badge-info"><?php echo htmlspecialchars($transf['obreiro_tipo']); ?></span></td>
                    <td><?php echo htmlspecialchars($transf['igreja_origem_nome'] ?? '-'); ?></td>
                    <td><?php echo htmlspecialchars($transf['igreja_destino_nome']); ?></td>
                    <td><?php echo htmlspecialchars($transf['motivo'] ?? '-'); ?></td>
                    <td><?php echo htmlspecialchars($transf['criado_por_nome']); ?></td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
      <!-- /.card-body -->
    </div>
    <!-- /.card -->
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

