<?php
$pageTitle = 'Transferências de Pastores';
$breadcrumb = [
    ['label' => 'Transferências', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">🔁 Transferências de Pastores</h3>
        <div class="card-tools">
          <a href="<?php echo BASE_URL; ?>index.php?c=Transferencia&a=criarTransferenciaPastor" class="btn btn-primary btn-sm">
            <i class="fas fa-plus"></i> Nova Transferência
          </a>
        </div>
      </div>
      <!-- /.card-header -->
      <div class="card-body">
        <!-- Filtros -->
        <form method="get" action="<?php echo BASE_URL; ?>index.php?c=Transferencia&a=pastores" class="mb-3">
          <div class="row">
            <div class="col-md-3">
              <select name="id_pastor" class="form-control">
                <option value="">Todos os pastores</option>
                <?php foreach ($pastores as $pastor): ?>
                  <option value="<?php echo $pastor['id']; ?>" 
                          <?php echo (isset($_GET['id_pastor']) && $_GET['id_pastor'] == $pastor['id']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($pastor['nome']); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-3">
              <input type="date" name="data_inicio" class="form-control" 
                     value="<?php echo htmlspecialchars($_GET['data_inicio'] ?? ''); ?>" placeholder="Data início">
            </div>
            <div class="col-md-3">
              <input type="date" name="data_fim" class="form-control" 
                     value="<?php echo htmlspecialchars($_GET['data_fim'] ?? ''); ?>" placeholder="Data fim">
            </div>
            <div class="col-md-3">
              <button type="submit" class="btn btn-info">
                <i class="fas fa-search"></i> Filtrar
              </button>
            </div>
          </div>
        </form>

        <div class="table-responsive">
          <table class="table table-hover">
            <thead>
              <tr>
                <th>Data</th>
                <th>Pastor</th>
                <th>Origem</th>
                <th>Destino</th>
                <th>Motivo</th>
                <th>Registrado por</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($transferencias)): ?>
                <tr>
                  <td colspan="6" class="text-center text-muted">Nenhuma transferência encontrada</td>
                </tr>
              <?php else: ?>
                <?php foreach ($transferencias as $transf): ?>
                  <tr>
                    <td><?php echo formatarData($transf['data_transferencia']); ?></td>
                    <td><?php echo htmlspecialchars($transf['pastor_nome']); ?></td>
                    <td><?php echo htmlspecialchars($transf['igreja_origem_nome'] ?? '-'); ?></td>
                    <td><?php echo htmlspecialchars($transf['igreja_destino_nome']); ?></td>
                    <td><?php echo htmlspecialchars($transf['motivo'] ?? '-'); ?></td>
                    <td><?php echo htmlspecialchars($transf['criado_por_nome']); ?></td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
      <!-- /.card-body -->
    </div>
    <!-- /.card -->
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

