<?php
$isEdit = isset($usuario) && !empty($usuario);
$pageTitle = $isEdit ? 'Editar Usuário' : 'Novo Usuário';
$breadcrumb = [
    ['label' => 'Usuários', 'url' => BASE_URL . 'index.php?c=Usuario&a=index'],
    ['label' => $isEdit ? 'Editar' : 'Novo', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-md-12">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title"><?php echo $isEdit ? 'Editar' : 'Cadastrar'; ?> Usuário</h3>
      </div>
      <!-- /.card-header -->
      <form action="<?php echo BASE_URL; ?>index.php?c=Usuario&a=<?php echo $isEdit ? 'editar&id=' . $usuario['id'] : 'criar'; ?>" method="post">
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="nome">Nome Completo <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nome" name="nome" 
                       value="<?php echo htmlspecialchars($usuario['nome'] ?? ''); ?>" required>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="email">E-mail <span class="text-danger">*</span></label>
                <input type="email" class="form-control" id="email" name="email" 
                       value="<?php echo htmlspecialchars($usuario['email'] ?? ''); ?>" required>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="senha">Senha <?php echo $isEdit ? '(deixe em branco para manter a atual)' : ''; ?> <span class="text-danger"><?php echo $isEdit ? '' : '*'; ?></span></label>
                <input type="password" class="form-control" id="senha" name="senha" 
                       <?php echo $isEdit ? '' : 'required'; ?> 
                       minlength="<?php echo PASSWORD_MIN_LENGTH; ?>"
                       placeholder="<?php echo $isEdit ? 'Deixe em branco para manter' : 'Mínimo ' . PASSWORD_MIN_LENGTH . ' caracteres'; ?>">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="id_perfil">Perfil <span class="text-danger">*</span></label>
                <select class="form-control" id="id_perfil" name="id_perfil" required>
                  <option value="">Selecione...</option>
                  <?php foreach ($perfis as $perfil): ?>
                    <option value="<?php echo $perfil['id']; ?>" 
                            <?php echo (isset($usuario['id_perfil']) && $usuario['id_perfil'] == $perfil['id']) ? 'selected' : ''; ?>>
                      <?php echo htmlspecialchars($perfil['nome']); ?> - <?php echo htmlspecialchars($perfil['descricao'] ?? ''); ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <div class="custom-control custom-switch">
                  <input type="checkbox" class="custom-control-input" id="ativo" name="ativo" 
                         <?php echo (!isset($usuario) || $usuario['ativo']) ? 'checked' : ''; ?>>
                  <label class="custom-control-label" for="ativo">Usuário Ativo</label>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /.card-body -->
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Salvar
          </button>
          <a href="<?php echo BASE_URL; ?>index.php?c=Usuario&a=index" class="btn btn-default">
            <i class="fas fa-times"></i> Cancelar
          </a>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

