<?php
$pageTitle = 'Usuários';
$breadcrumb = [
    ['label' => 'Administração', 'url' => '#'],
    ['label' => 'Usuários', 'url' => '#', 'active' => true]
];
include __DIR__ . '/../layouts/footer.php';
?>

<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">Usuários do Sistema</h3>
        <div class="card-tools">
          <a href="<?php echo BASE_URL; ?>index.php?c=Usuario&a=criar" class="btn btn-primary btn-sm">
            <i class="fas fa-plus"></i> Novo Usuário
          </a>
        </div>
      </div>
      <!-- /.card-header -->
      <div class="card-body table-responsive p-0">
        <table class="table table-hover">
          <thead>
            <tr>
              <th>ID</th>
              <th>Nome</th>
              <th>E-mail</th>
              <th>Perfil</th>
              <th>Status</th>
              <th>Último Acesso</th>
              <th>Ações</th>
            </tr>
          </thead>
          <tbody>
            <?php if (empty($usuarios)): ?>
              <tr>
                <td colspan="7" class="text-center text-muted">Nenhum usuário cadastrado</td>
              </tr>
            <?php else: ?>
              <?php foreach ($usuarios as $usuario): ?>
                <tr>
                  <td><?php echo $usuario['id']; ?></td>
                  <td><?php echo htmlspecialchars($usuario['nome']); ?></td>
                  <td><?php echo htmlspecialchars($usuario['email']); ?></td>
                  <td><?php echo htmlspecialchars($usuario['perfil_nome']); ?></td>
                  <td>
                    <?php if ($usuario['ativo']): ?>
                      <span class="badge badge-success">Ativo</span>
                    <?php else: ?>
                      <span class="badge badge-secondary">Inativo</span>
                    <?php endif; ?>
                  </td>
                  <td><?php echo formatarData($usuario['ultimo_acesso'], 'd/m/Y H:i'); ?></td>
                  <td>
                    <a href="<?php echo BASE_URL; ?>index.php?c=Usuario&a=editar&id=<?php echo $usuario['id']; ?>" 
                       class="btn btn-sm btn-warning" title="Editar">
                      <i class="fas fa-edit"></i>
                    </a>
                    <?php if ($usuario['id'] != $_SESSION['usuario_id']): ?>
                      <a href="<?php echo BASE_URL; ?>index.php?c=Usuario&a=excluir&id=<?php echo $usuario['id']; ?>" 
                         class="btn btn-sm btn-danger" 
                         onclick="return confirm('Tem certeza que deseja excluir este usuário?');" 
                         title="Excluir">
                        <i class="fas fa-trash"></i>
                      </a>
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      <!-- /.card-body -->
    </div>
    <!-- /.card -->
  </div>
</div>

<?php include __DIR__ . '/../layouts/footer_end.php'; ?>

