<?php
/**
 * Sistema de Gestão de Igrejas (SGI)
 * Arquivo principal de roteamento
 */

// Carregar configurações
require_once __DIR__ . '/../app/config/config.php';
require_once __DIR__ . '/../app/config/database.php';
require_once __DIR__ . '/../app/helpers/functions.php';

// Roteamento simples
$controller = isset($_GET['c']) ? sanitizar($_GET['c']) : 'Dashboard';
$action = isset($_GET['a']) ? sanitizar($_GET['a']) : 'index';

$controllerName = $controller . 'Controller';
$controllerFile = __DIR__ . "/../app/controllers/{$controllerName}.php";

if (file_exists($controllerFile)) {
    require_once $controllerFile;
    
    if (class_exists($controllerName)) {
        $obj = new $controllerName();
        
        if (method_exists($obj, $action)) {
            $obj->$action();
        } else {
            die("Ação '{$action}' não encontrada no controller '{$controllerName}'.");
        }
    } else {
        die("Classe '{$controllerName}' não encontrada.");
    }
} else {
    die("Controller '{$controllerName}' não encontrado.");
}

